/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.conf;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.accumulo.core.util.CachedConfiguration;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CredentialProviderFactoryShim {
    private static final Logger log = LoggerFactory.getLogger(CredentialProviderFactoryShim.class);
    public static final String HADOOP_CRED_PROVIDER_FACTORY_CLASS_NAME = "org.apache.hadoop.security.alias.JavaKeyStoreProvider$Factory";
    public static final String HADOOP_CRED_PROVIDER_FACTORY_GET_PROVIDERS_METHOD_NAME = "getProviders";
    public static final String HADOOP_CRED_PROVIDER_CLASS_NAME = "org.apache.hadoop.security.alias.CredentialProvider";
    public static final String HADOOP_CRED_PROVIDER_GET_CREDENTIAL_ENTRY_METHOD_NAME = "getCredentialEntry";
    public static final String HADOOP_CRED_PROVIDER_GET_ALIASES_METHOD_NAME = "getAliases";
    public static final String HADOOP_CRED_PROVIDER_CREATE_CREDENTIAL_ENTRY_METHOD_NAME = "createCredentialEntry";
    public static final String HADOOP_CRED_PROVIDER_FLUSH_METHOD_NAME = "flush";
    public static final String HADOOP_CRED_ENTRY_CLASS_NAME = "org.apache.hadoop.security.alias.CredentialProvider$CredentialEntry";
    public static final String HADOOP_CRED_ENTRY_GET_CREDENTIAL_METHOD_NAME = "getCredential";
    public static final String CREDENTIAL_PROVIDER_PATH = "hadoop.security.credential.provider.path";
    private static Object hadoopCredProviderFactory = null;
    private static Method getProvidersMethod = null;
    private static Method getAliasesMethod = null;
    private static Method getCredentialEntryMethod = null;
    private static Method getCredentialMethod = null;
    private static Method createCredentialEntryMethod = null;
    private static Method flushMethod = null;
    private static Boolean hadoopClassesAvailable = null;
    private static final ConcurrentHashMap<String, List<Object>> cachedProviders = new ConcurrentHashMap();

    public static synchronized boolean isHadoopCredentialProviderAvailable() {
        if (null != hadoopClassesAvailable) {
            return hadoopClassesAvailable != false && null != getProvidersMethod && null != hadoopCredProviderFactory && null != getCredentialEntryMethod && null != getCredentialMethod;
        }
        hadoopClassesAvailable = false;
        Class<?> hadoopCredProviderFactoryClz = null;
        try {
            hadoopCredProviderFactoryClz = Class.forName(HADOOP_CRED_PROVIDER_FACTORY_CLASS_NAME);
        }
        catch (ClassNotFoundException e) {
            log.trace("Could not load class {}", (Object)HADOOP_CRED_PROVIDER_FACTORY_CLASS_NAME, (Object)e);
            return false;
        }
        try {
            getProvidersMethod = hadoopCredProviderFactoryClz.getMethod(HADOOP_CRED_PROVIDER_FACTORY_GET_PROVIDERS_METHOD_NAME, Configuration.class);
        }
        catch (SecurityException e) {
            log.trace("Could not find {} method on {}", new Object[]{HADOOP_CRED_PROVIDER_FACTORY_GET_PROVIDERS_METHOD_NAME, HADOOP_CRED_PROVIDER_FACTORY_CLASS_NAME, e});
            return false;
        }
        catch (NoSuchMethodException e) {
            log.trace("Could not find {} method on {}", new Object[]{HADOOP_CRED_PROVIDER_FACTORY_GET_PROVIDERS_METHOD_NAME, HADOOP_CRED_PROVIDER_FACTORY_CLASS_NAME, e});
            return false;
        }
        try {
            hadoopCredProviderFactory = hadoopCredProviderFactoryClz.newInstance();
        }
        catch (InstantiationException e) {
            log.trace("Could not instantiate class {}", (Object)HADOOP_CRED_PROVIDER_FACTORY_CLASS_NAME, (Object)e);
            return false;
        }
        catch (IllegalAccessException e) {
            log.trace("Could not instantiate class {}", (Object)HADOOP_CRED_PROVIDER_FACTORY_CLASS_NAME, (Object)e);
            return false;
        }
        Class<?> hadoopCredProviderClz = null;
        try {
            hadoopCredProviderClz = Class.forName(HADOOP_CRED_PROVIDER_CLASS_NAME);
        }
        catch (ClassNotFoundException e) {
            log.trace("Could not load class {}", (Object)HADOOP_CRED_PROVIDER_CLASS_NAME, (Object)e);
            return false;
        }
        try {
            getCredentialEntryMethod = hadoopCredProviderClz.getMethod(HADOOP_CRED_PROVIDER_GET_CREDENTIAL_ENTRY_METHOD_NAME, String.class);
        }
        catch (SecurityException e) {
            log.trace("Could not find {} method on {}", new Object[]{HADOOP_CRED_PROVIDER_GET_CREDENTIAL_ENTRY_METHOD_NAME, HADOOP_CRED_PROVIDER_CLASS_NAME, e});
            return false;
        }
        catch (NoSuchMethodException e) {
            log.trace("Could not find {} method on {}", new Object[]{HADOOP_CRED_PROVIDER_GET_CREDENTIAL_ENTRY_METHOD_NAME, HADOOP_CRED_PROVIDER_CLASS_NAME, e});
            return false;
        }
        try {
            getAliasesMethod = hadoopCredProviderClz.getMethod(HADOOP_CRED_PROVIDER_GET_ALIASES_METHOD_NAME, new Class[0]);
        }
        catch (SecurityException e) {
            log.trace("Could not find {} method on {}", new Object[]{HADOOP_CRED_PROVIDER_GET_ALIASES_METHOD_NAME, HADOOP_CRED_PROVIDER_CLASS_NAME, e});
            return false;
        }
        catch (NoSuchMethodException e) {
            log.trace("Could not find {} method on {}", new Object[]{HADOOP_CRED_PROVIDER_GET_ALIASES_METHOD_NAME, HADOOP_CRED_PROVIDER_CLASS_NAME, e});
            return false;
        }
        try {
            createCredentialEntryMethod = hadoopCredProviderClz.getMethod(HADOOP_CRED_PROVIDER_CREATE_CREDENTIAL_ENTRY_METHOD_NAME, String.class, char[].class);
        }
        catch (SecurityException e) {
            log.trace("Could not find {} method on {}", new Object[]{HADOOP_CRED_PROVIDER_CREATE_CREDENTIAL_ENTRY_METHOD_NAME, HADOOP_CRED_PROVIDER_CLASS_NAME, e});
            return false;
        }
        catch (NoSuchMethodException e) {
            log.trace("Could not find {} method on {}", new Object[]{HADOOP_CRED_PROVIDER_CREATE_CREDENTIAL_ENTRY_METHOD_NAME, HADOOP_CRED_PROVIDER_CLASS_NAME, e});
            return false;
        }
        try {
            flushMethod = hadoopCredProviderClz.getMethod(HADOOP_CRED_PROVIDER_FLUSH_METHOD_NAME, new Class[0]);
        }
        catch (SecurityException e) {
            log.trace("Could not find {} method on {}", new Object[]{HADOOP_CRED_PROVIDER_FLUSH_METHOD_NAME, HADOOP_CRED_PROVIDER_CLASS_NAME, e});
            return false;
        }
        catch (NoSuchMethodException e) {
            log.trace("Could not find {} method on {}", new Object[]{HADOOP_CRED_PROVIDER_FLUSH_METHOD_NAME, HADOOP_CRED_PROVIDER_CLASS_NAME, e});
            return false;
        }
        Class<?> hadoopCredentialEntryClz = null;
        try {
            hadoopCredentialEntryClz = Class.forName(HADOOP_CRED_ENTRY_CLASS_NAME);
        }
        catch (ClassNotFoundException e) {
            log.trace("Could not load class {}", (Object)HADOOP_CRED_ENTRY_CLASS_NAME);
            return false;
        }
        try {
            getCredentialMethod = hadoopCredentialEntryClz.getMethod(HADOOP_CRED_ENTRY_GET_CREDENTIAL_METHOD_NAME, new Class[0]);
        }
        catch (SecurityException e) {
            log.trace("Could not find {} method on {}", new Object[]{HADOOP_CRED_ENTRY_GET_CREDENTIAL_METHOD_NAME, HADOOP_CRED_ENTRY_CLASS_NAME, e});
            return false;
        }
        catch (NoSuchMethodException e) {
            log.trace("Could not find {} method on {}", new Object[]{HADOOP_CRED_ENTRY_GET_CREDENTIAL_METHOD_NAME, HADOOP_CRED_ENTRY_CLASS_NAME, e});
            return false;
        }
        hadoopClassesAvailable = true;
        return true;
    }

    protected static List<Object> getCredentialProviders(Configuration conf) {
        String path = conf.get(CREDENTIAL_PROVIDER_PATH);
        if (path == null || path.isEmpty()) {
            return null;
        }
        List providersList = cachedProviders.get(path);
        if (providersList != null) {
            return providersList;
        }
        Object providersObj = null;
        try {
            providersObj = getProvidersMethod.invoke(hadoopCredProviderFactory, conf);
        }
        catch (IllegalArgumentException e) {
            log.warn("Could not invoke {}.{}", new Object[]{HADOOP_CRED_PROVIDER_FACTORY_CLASS_NAME, HADOOP_CRED_PROVIDER_FACTORY_GET_PROVIDERS_METHOD_NAME, e});
            return null;
        }
        catch (IllegalAccessException e) {
            log.warn("Could not invoke {}.{}", new Object[]{HADOOP_CRED_PROVIDER_FACTORY_CLASS_NAME, HADOOP_CRED_PROVIDER_FACTORY_GET_PROVIDERS_METHOD_NAME, e});
            return null;
        }
        catch (InvocationTargetException e) {
            log.warn("Could not invoke {}.{}", new Object[]{HADOOP_CRED_PROVIDER_FACTORY_CLASS_NAME, HADOOP_CRED_PROVIDER_FACTORY_GET_PROVIDERS_METHOD_NAME, e});
            return null;
        }
        try {
            providersList = (List)providersObj;
            List<Object> previousValue = cachedProviders.putIfAbsent(path, providersList);
            if (previousValue != null) {
                return previousValue;
            }
            return providersList;
        }
        catch (ClassCastException e) {
            log.error("Expected a List from {} method", (Object)HADOOP_CRED_PROVIDER_FACTORY_GET_PROVIDERS_METHOD_NAME, (Object)e);
            return null;
        }
    }

    protected static char[] getFromHadoopCredentialProvider(Configuration conf, String alias) {
        List<Object> providerObjList = CredentialProviderFactoryShim.getCredentialProviders(conf);
        if (null == providerObjList) {
            return null;
        }
        for (Object providerObj : providerObjList) {
            try {
                Object credEntryObj = getCredentialEntryMethod.invoke(providerObj, alias);
                if (null == credEntryObj) continue;
                Object credential = getCredentialMethod.invoke(credEntryObj, new Object[0]);
                return (char[])credential;
            }
            catch (IllegalArgumentException e) {
                log.warn("Failed to get credential for {} from {}", new Object[]{alias, providerObj, e});
            }
            catch (IllegalAccessException e) {
                log.warn("Failed to get credential for {} from {}", new Object[]{alias, providerObj, e});
            }
            catch (InvocationTargetException e) {
                log.warn("Failed to get credential for {} from {}", new Object[]{alias, providerObj, e});
            }
        }
        log.trace("Could not extract credential for {} from providers", (Object)alias);
        return null;
    }

    protected static List<String> getAliasesFromHadoopCredentialProvider(Configuration conf) {
        List<Object> providerObjList = CredentialProviderFactoryShim.getCredentialProviders(conf);
        if (null == providerObjList) {
            log.debug("Failed to get CredProviders");
            return Collections.emptyList();
        }
        ArrayList<String> aliases = new ArrayList<String>();
        for (Object providerObj : providerObjList) {
            if (null == providerObj) continue;
            try {
                Object aliasesObj = getAliasesMethod.invoke(providerObj, new Object[0]);
                if (null == aliasesObj || !(aliasesObj instanceof List)) continue;
                try {
                    aliases.addAll((List)aliasesObj);
                }
                catch (ClassCastException e) {
                    log.warn("Could not cast aliases ({}) from {} to a List<String>", new Object[]{aliasesObj, providerObj, e});
                }
            }
            catch (IllegalArgumentException e) {
                log.warn("Failed to invoke {} on {}", new Object[]{HADOOP_CRED_PROVIDER_GET_ALIASES_METHOD_NAME, providerObj, e});
            }
            catch (IllegalAccessException e) {
                log.warn("Failed to invoke {} on {}", new Object[]{HADOOP_CRED_PROVIDER_GET_ALIASES_METHOD_NAME, providerObj, e});
            }
            catch (InvocationTargetException e) {
                log.warn("Failed to invoke {} on {}", new Object[]{HADOOP_CRED_PROVIDER_GET_ALIASES_METHOD_NAME, providerObj, e});
            }
        }
        return aliases;
    }

    public static Configuration getConfiguration(String credentialProviders) {
        Objects.requireNonNull(credentialProviders);
        return CredentialProviderFactoryShim.getConfiguration(new Configuration(CachedConfiguration.getInstance()), credentialProviders);
    }

    public static Configuration getConfiguration(Configuration conf, String credentialProviders) {
        Objects.requireNonNull(conf);
        Objects.requireNonNull(credentialProviders);
        conf.set(CREDENTIAL_PROVIDER_PATH, credentialProviders);
        return conf;
    }

    public static char[] getValueFromCredentialProvider(Configuration conf, String alias) throws IOException {
        Objects.requireNonNull(conf);
        Objects.requireNonNull(alias);
        if (CredentialProviderFactoryShim.isHadoopCredentialProviderAvailable()) {
            log.trace("Hadoop CredentialProvider is available, attempting to extract value for {}", (Object)alias);
            return CredentialProviderFactoryShim.getFromHadoopCredentialProvider(conf, alias);
        }
        return null;
    }

    public static List<String> getKeys(Configuration conf) throws IOException {
        Objects.requireNonNull(conf);
        if (CredentialProviderFactoryShim.isHadoopCredentialProviderAvailable()) {
            log.trace("Hadoop CredentialProvider is available, attempting to extract all aliases");
            return CredentialProviderFactoryShim.getAliasesFromHadoopCredentialProvider(conf);
        }
        return Collections.emptyList();
    }

    public static void createEntry(Configuration conf, String name, char[] credential) throws IOException {
        Objects.requireNonNull(conf);
        Objects.requireNonNull(name);
        Objects.requireNonNull(credential);
        if (!CredentialProviderFactoryShim.isHadoopCredentialProviderAvailable()) {
            log.warn("Hadoop CredentialProvider is not available");
            return;
        }
        List<Object> providers = CredentialProviderFactoryShim.getCredentialProviders(conf);
        if (null == providers) {
            throw new IOException("Could not fetch any CredentialProviders, is the implementation available?");
        }
        if (1 != providers.size()) {
            log.warn("Found more than one CredentialProvider. Using first provider found");
        }
        Object provider = providers.get(0);
        CredentialProviderFactoryShim.createEntryInProvider(provider, name, credential);
    }

    public static void createEntryInProvider(Object credentialProvider, String name, char[] credential) throws IOException {
        Objects.requireNonNull(credentialProvider);
        Objects.requireNonNull(name);
        Objects.requireNonNull(credential);
        if (!CredentialProviderFactoryShim.isHadoopCredentialProviderAvailable()) {
            log.warn("Hadoop CredentialProvider is not available");
            return;
        }
        try {
            createCredentialEntryMethod.invoke(credentialProvider, name, credential);
        }
        catch (IllegalArgumentException e) {
            log.warn("Failed to invoke createCredentialEntry method on CredentialProvider", (Throwable)e);
            return;
        }
        catch (IllegalAccessException e) {
            log.warn("Failed to invoke createCredentialEntry method", (Throwable)e);
            return;
        }
        catch (InvocationTargetException e) {
            log.warn("Failed to invoke createCredentialEntry method", (Throwable)e);
            return;
        }
        try {
            flushMethod.invoke(credentialProvider, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            log.warn("Failed to invoke flush method on CredentialProvider", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.warn("Failed to invoke flush method on CredentialProvider", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            log.warn("Failed to invoke flush method on CredentialProvider", (Throwable)e);
        }
    }
}

