/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.common.caches;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.PropertyKey;
import org.apache.helix.common.caches.AbstractDataCache;
import org.apache.helix.common.caches.CurrentStateSnapshot;
import org.apache.helix.common.controllers.ControlContextProvider;
import org.apache.helix.controller.LogUtil;
import org.apache.helix.model.CurrentState;
import org.apache.helix.model.LiveInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CurrentStateCache
extends AbstractDataCache<CurrentState> {
    private static final Logger LOG = LoggerFactory.getLogger((String)CurrentStateCache.class.getName());
    private Map<String, Map<String, Map<String, CurrentState>>> _currentStateMap;
    private Map<PropertyKey, CurrentState> _currentStateCache = Maps.newHashMap();
    private boolean _initialized = false;
    private CurrentStateSnapshot _snapshot;

    public CurrentStateCache(String clusterName) {
        this(CurrentStateCache.createDefaultControlContextProvider(clusterName));
    }

    public CurrentStateCache(ControlContextProvider contextProvider) {
        super(contextProvider);
        this._currentStateMap = Collections.emptyMap();
        this._snapshot = new CurrentStateSnapshot(this._currentStateCache);
    }

    public boolean refresh(HelixDataAccessor accessor, Map<String, LiveInstance> liveInstanceMap) {
        long startTime = System.currentTimeMillis();
        this.refreshCurrentStatesCache(accessor, liveInstanceMap);
        HashMap allCurStateMap = new HashMap();
        for (PropertyKey key : this._currentStateCache.keySet()) {
            Map sessionCurStateMap;
            CurrentState currentState = this._currentStateCache.get(key);
            String[] params = key.getParams();
            if (currentState == null || params.length < 4) continue;
            String instanceName = params[1];
            String sessionId = params[2];
            String stateName = params[3];
            Map instanceCurStateMap = (Map)allCurStateMap.get(instanceName);
            if (instanceCurStateMap == null) {
                instanceCurStateMap = Maps.newHashMap();
                allCurStateMap.put(instanceName, instanceCurStateMap);
            }
            if ((sessionCurStateMap = (Map)instanceCurStateMap.get(sessionId)) == null) {
                sessionCurStateMap = Maps.newHashMap();
                instanceCurStateMap.put(sessionId, sessionCurStateMap);
            }
            sessionCurStateMap.put(stateName, currentState);
        }
        for (String instance : allCurStateMap.keySet()) {
            allCurStateMap.put(instance, Collections.unmodifiableMap((Map)allCurStateMap.get(instance)));
        }
        this._currentStateMap = Collections.unmodifiableMap(allCurStateMap);
        long endTime = System.currentTimeMillis();
        LogUtil.logInfo(LOG, this.genEventInfo(), "END: CurrentStateCache.refresh() for cluster " + this._controlContextProvider.getClusterName() + ", started at : " + startTime + ", took " + (endTime - startTime) + " ms");
        if (LOG.isDebugEnabled()) {
            LogUtil.logDebug(LOG, this.genEventInfo(), String.format("Current State refreshed : %s", this._currentStateMap.toString()));
        }
        return true;
    }

    private void refreshCurrentStatesCache(HelixDataAccessor accessor, Map<String, LiveInstance> liveInstanceMap) {
        long start = System.currentTimeMillis();
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        HashSet<PropertyKey> currentStateKeys = new HashSet<PropertyKey>();
        for (String instanceName : liveInstanceMap.keySet()) {
            LiveInstance liveInstance = liveInstanceMap.get(instanceName);
            String sessionId = liveInstance.getEphemeralOwner();
            List<String> currentStateNames = accessor.getChildNames(keyBuilder.currentStates(instanceName, sessionId));
            for (String currentStateName : currentStateNames) {
                currentStateKeys.add(keyBuilder.currentState(instanceName, sessionId, currentStateName));
            }
        }
        HashSet<PropertyKey> reloadKeys = new HashSet<PropertyKey>(currentStateKeys);
        reloadKeys.removeAll(this._currentStateCache.keySet());
        HashSet<PropertyKey> cachedKeys = new HashSet<PropertyKey>(this._currentStateCache.keySet());
        cachedKeys.retainAll(currentStateKeys);
        HashSet<PropertyKey> reloadedKeys = new HashSet<PropertyKey>();
        Map<PropertyKey, CurrentState> newStateCache = Collections.unmodifiableMap(this.refreshProperties(accessor, reloadKeys, new ArrayList<PropertyKey>(cachedKeys), this._currentStateCache, reloadedKeys));
        if (this._initialized) {
            this._snapshot = new CurrentStateSnapshot(newStateCache, this._currentStateCache, reloadedKeys);
        } else {
            this._snapshot = new CurrentStateSnapshot(newStateCache);
            this._initialized = true;
        }
        this._currentStateCache = newStateCache;
        if (LOG.isDebugEnabled()) {
            LogUtil.logDebug(LOG, this.genEventInfo(), "# of CurrentStates reload: " + reloadKeys.size() + ", skipped:" + (currentStateKeys.size() - reloadKeys.size()) + ". took " + (System.currentTimeMillis() - start) + " ms to reload new current states for cluster: " + this._controlContextProvider.getClusterName());
        }
    }

    public Map<String, Map<String, Map<String, CurrentState>>> getCurrentStatesMap() {
        return Collections.unmodifiableMap(this._currentStateMap);
    }

    public Map<String, Map<String, CurrentState>> getCurrentStates(String instance) {
        if (!this._currentStateMap.containsKey(instance)) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this._currentStateMap.get(instance));
    }

    public Map<String, CurrentState> getCurrentState(String instance, String clientSessionId) {
        if (!this._currentStateMap.containsKey(instance) || !this._currentStateMap.get(instance).containsKey(clientSessionId)) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this._currentStateMap.get(instance).get(clientSessionId));
    }

    @Override
    public CurrentStateSnapshot getSnapshot() {
        return this._snapshot;
    }
}

