/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.common;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.helix.controller.common.PartitionStateMap;
import org.apache.helix.model.Partition;

public class ResourcesStateMap {
    protected Map<String, PartitionStateMap> _resourceStateMap = new HashMap<String, PartitionStateMap>();

    public Set<String> resourceSet() {
        return this._resourceStateMap.keySet();
    }

    public void setState(String resourceName, Partition partition, Map<String, String> instanceStateMappingForPartition) {
        if (!this._resourceStateMap.containsKey(resourceName)) {
            this._resourceStateMap.put(resourceName, new PartitionStateMap(resourceName));
        }
        PartitionStateMap partitionStateMap = this._resourceStateMap.get(resourceName);
        partitionStateMap.setState(partition, instanceStateMappingForPartition);
    }

    public void setState(String resourceName, Map<Partition, Map<String, String>> instanceStateMappingForResource) {
        this._resourceStateMap.put(resourceName, new PartitionStateMap(resourceName, instanceStateMappingForResource));
    }

    public void setState(String resourceName, PartitionStateMap partitionStateMapForResource) {
        this._resourceStateMap.put(resourceName, partitionStateMapForResource);
    }

    public void setState(String resourceName, Partition partition, String instance, String state) {
        if (!this._resourceStateMap.containsKey(resourceName)) {
            this._resourceStateMap.put(resourceName, new PartitionStateMap(resourceName));
        }
        this._resourceStateMap.get(resourceName).setState(partition, instance, state);
    }

    public Map<String, String> getInstanceStateMap(String resourceName, Partition partition) {
        PartitionStateMap stateMap = this._resourceStateMap.get(resourceName);
        if (stateMap != null) {
            return stateMap.getPartitionMap(partition);
        }
        return Collections.emptyMap();
    }

    public PartitionStateMap getPartitionStateMap(String resourceName) {
        PartitionStateMap stateMap = this._resourceStateMap.get(resourceName);
        if (stateMap != null) {
            return stateMap;
        }
        return new PartitionStateMap(resourceName);
    }

    public Map<String, PartitionStateMap> getResourceStatesMap() {
        return this._resourceStateMap;
    }

    public String toString() {
        return this._resourceStateMap.toString();
    }
}

