/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.http.server;

import com.facebook.airlift.event.client.EventClient;
import com.facebook.airlift.http.server.Authorizer;
import com.facebook.airlift.http.server.HttpServer;
import com.facebook.airlift.http.server.HttpServerBinder;
import com.facebook.airlift.http.server.HttpServerConfig;
import com.facebook.airlift.http.server.HttpServerInfo;
import com.facebook.airlift.http.server.HttpsConfig;
import com.facebook.airlift.http.server.RequestStats;
import com.facebook.airlift.http.server.TheAdminServlet;
import com.facebook.airlift.http.server.TheServlet;
import com.facebook.airlift.node.NodeInfo;
import com.facebook.airlift.tracetoken.TraceTokenManager;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Provider;
import javax.management.MBeanServer;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class HttpServerProvider
implements Provider<HttpServer> {
    private final HttpServerInfo httpServerInfo;
    private final NodeInfo nodeInfo;
    private final HttpServerConfig config;
    private final Optional<HttpsConfig> httpsConfig;
    private final Servlet defaultServlet;
    private final Map<String, Servlet> servlets;
    private final Set<HttpServerBinder.HttpResourceBinding> resources;
    private final HttpServer.ClientCertificate clientCertificate;
    private Map<String, String> servletInitParameters = ImmutableMap.of();
    private Servlet theAdminServlet;
    private Map<String, String> adminServletInitParameters = ImmutableMap.of();
    private MBeanServer mbeanServer;
    private LoginService loginService;
    private final RequestStats stats;
    private final Set<Filter> filters;
    private final Set<Filter> adminFilters;
    private TraceTokenManager traceTokenManager;
    private final EventClient eventClient;
    private Authorizer authorizer;
    private final Optional<SslContextFactory.Server> sslContextFactory;

    @Inject
    public HttpServerProvider(HttpServerInfo httpServerInfo, NodeInfo nodeInfo, HttpServerConfig config, Optional<HttpsConfig> httpsConfig, @TheServlet Servlet defaultServlet, @TheServlet Map<String, Servlet> servlets, @TheServlet Set<Filter> filters, @TheServlet Set<HttpServerBinder.HttpResourceBinding> resources, @TheAdminServlet Set<Filter> adminFilters, HttpServer.ClientCertificate clientCertificate, RequestStats stats, EventClient eventClient, Optional<SslContextFactory.Server> sslContextFactory) {
        Objects.requireNonNull(httpServerInfo, "httpServerInfo is null");
        Objects.requireNonNull(nodeInfo, "nodeInfo is null");
        Objects.requireNonNull(config, "config is null");
        Objects.requireNonNull(httpsConfig, "httpsConfig is null");
        Objects.requireNonNull(defaultServlet, "defaultServlet is null");
        Objects.requireNonNull(servlets, "servlets is null");
        Objects.requireNonNull(filters, "filters is null");
        Objects.requireNonNull(resources, "resources is null");
        Objects.requireNonNull(adminFilters, "adminFilters is null");
        Objects.requireNonNull(clientCertificate, "clientCertificate is null");
        Objects.requireNonNull(stats, "stats is null");
        Objects.requireNonNull(eventClient, "eventClient is null");
        Objects.requireNonNull(sslContextFactory, "sslContextFactory is null");
        this.httpServerInfo = httpServerInfo;
        this.nodeInfo = nodeInfo;
        this.config = config;
        this.httpsConfig = httpsConfig;
        this.defaultServlet = defaultServlet;
        this.servlets = servlets;
        this.filters = ImmutableSet.copyOf(filters);
        this.resources = ImmutableSet.copyOf(resources);
        this.adminFilters = ImmutableSet.copyOf(adminFilters);
        this.clientCertificate = clientCertificate;
        this.stats = stats;
        this.eventClient = eventClient;
        this.sslContextFactory = sslContextFactory;
    }

    @Inject(optional=true)
    public void setServletInitParameters(@TheServlet Map<String, String> parameters) {
        this.servletInitParameters = ImmutableMap.copyOf(parameters);
    }

    @Inject(optional=true)
    public void setTheAdminServlet(@TheAdminServlet Servlet theAdminServlet) {
        this.theAdminServlet = theAdminServlet;
    }

    @Inject(optional=true)
    public void setAdminServletInitParameters(@TheAdminServlet Map<String, String> parameters) {
        this.adminServletInitParameters = ImmutableMap.copyOf(parameters);
    }

    @Inject(optional=true)
    public void setMBeanServer(MBeanServer server) {
        this.mbeanServer = server;
    }

    @Inject(optional=true)
    public void setLoginService(@Nullable LoginService loginService) {
        this.loginService = loginService;
    }

    @Inject(optional=true)
    public void setTokenManager(@Nullable TraceTokenManager tokenManager) {
        this.traceTokenManager = tokenManager;
    }

    @Inject(optional=true)
    public void setAuthorizer(@Nullable Authorizer authorizer) {
        this.authorizer = authorizer;
    }

    public HttpServer get() {
        try {
            HttpServer httpServer = new HttpServer(this.httpServerInfo, this.nodeInfo, this.config, this.httpsConfig, this.defaultServlet, this.servlets, this.servletInitParameters, this.filters, this.resources, this.theAdminServlet, this.adminServletInitParameters, this.adminFilters, this.clientCertificate, this.mbeanServer, this.loginService, this.traceTokenManager, this.stats, this.eventClient, this.authorizer, this.sslContextFactory);
            httpServer.start();
            return httpServer;
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

