/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.transport.netty.buffer;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.util.ResourceLeakDetector;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.GuardedBy;

public class TestingPooledByteBufAllocator
extends PooledByteBufAllocator
implements Closeable {
    @GuardedBy(value="this")
    private final List<ByteBuf> trackedBuffers = new ArrayList<ByteBuf>();
    private final ResourceLeakDetector.Level oldLevel;

    public TestingPooledByteBufAllocator() {
        this(TestingPooledByteBufAllocator.getAndSetResourceLeakDetectorLevel(ResourceLeakDetector.Level.PARANOID));
    }

    private static ResourceLeakDetector.Level getAndSetResourceLeakDetectorLevel(ResourceLeakDetector.Level newLevel) {
        ResourceLeakDetector.Level oldLevel = ResourceLeakDetector.getLevel();
        ResourceLeakDetector.setLevel((ResourceLeakDetector.Level)newLevel);
        return oldLevel;
    }

    private TestingPooledByteBufAllocator(ResourceLeakDetector.Level oldLevel) {
        super(false);
        this.oldLevel = oldLevel;
    }

    protected ByteBuf newHeapBuffer(int initialCapacity, int maxCapacity) {
        return this.track(super.newHeapBuffer(initialCapacity, maxCapacity));
    }

    protected ByteBuf newDirectBuffer(int initialCapacity, int maxCapacity) {
        return this.track(super.newDirectBuffer(initialCapacity, maxCapacity));
    }

    public CompositeByteBuf compositeHeapBuffer(int maxNumComponents) {
        return this.track(super.compositeHeapBuffer(maxNumComponents));
    }

    public CompositeByteBuf compositeDirectBuffer(int maxNumComponents) {
        return this.track(super.compositeDirectBuffer(maxNumComponents));
    }

    private synchronized CompositeByteBuf track(CompositeByteBuf byteBuf) {
        this.trackedBuffers.add((ByteBuf)byteBuf);
        return byteBuf;
    }

    private synchronized ByteBuf track(ByteBuf byteBuf) {
        this.trackedBuffers.add(byteBuf);
        return byteBuf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"DM_GC"}, justification="Netty's leak detection only works if buffer is garbage collected")
    public void close() {
        try {
            boolean leaked;
            TestingPooledByteBufAllocator testingPooledByteBufAllocator = this;
            synchronized (testingPooledByteBufAllocator) {
                leaked = this.trackedBuffers.stream().anyMatch(byteBuf -> byteBuf.refCnt() > 0);
                this.trackedBuffers.clear();
            }
            if (leaked) {
                System.gc();
                throw new AssertionError((Object)"LEAK");
            }
        }
        finally {
            ResourceLeakDetector.setLevel((ResourceLeakDetector.Level)this.oldLevel);
        }
    }
}

