/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.$internal.jodd.typeconverter.impl;

import com.facebook.presto.hive.$internal.jodd.JoddCore;
import com.facebook.presto.hive.$internal.jodd.typeconverter.TypeConversionException;
import com.facebook.presto.hive.$internal.jodd.typeconverter.TypeConverter;
import com.facebook.presto.hive.$internal.jodd.util.CsvUtil;
import java.io.UnsupportedEncodingException;
import java.sql.Clob;
import java.sql.SQLException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringConverter
implements TypeConverter<String> {
    @Override
    public String convert(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof CharSequence) {
            return value.toString();
        }
        Class<?> type = value.getClass();
        if (type == Class.class) {
            return ((Class)value).getName();
        }
        if (type.isArray()) {
            if (type == byte[].class) {
                byte[] valueArray = (byte[])value;
                try {
                    return new String(valueArray, 0, valueArray.length, JoddCore.encoding);
                }
                catch (UnsupportedEncodingException ueex) {
                    throw new TypeConversionException(ueex);
                }
            }
            if (type == char[].class) {
                char[] charArray = (char[])value;
                return new String(charArray);
            }
            return CsvUtil.toCsvString((Object[])value);
        }
        if (value instanceof Clob) {
            Clob clob = (Clob)value;
            try {
                long length = clob.length();
                if (length > Integer.MAX_VALUE) {
                    throw new TypeConversionException("Clob is too big.");
                }
                return clob.getSubString(1L, (int)length);
            }
            catch (SQLException sex) {
                throw new TypeConversionException(value, (Throwable)sex);
            }
        }
        return value.toString();
    }
}

