/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.mapreduce;

import com.facebook.presto.hive.$internal.org.slf4j.Logger;
import com.facebook.presto.hive.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.mapred.AvroKey;
import org.apache.avro.mapred.AvroValue;
import org.apache.avro.mapreduce.AvroJob;
import org.apache.avro.mapreduce.AvroKeyValueRecordReader;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;

public class AvroKeyValueInputFormat<K, V>
extends FileInputFormat<AvroKey<K>, AvroValue<V>> {
    private static final Logger LOG = LoggerFactory.getLogger(AvroKeyValueInputFormat.class);

    public RecordReader<AvroKey<K>, AvroValue<V>> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        Schema valueReaderSchema;
        Schema keyReaderSchema = AvroJob.getInputKeySchema(context.getConfiguration());
        if (null == keyReaderSchema) {
            LOG.warn("Key reader schema was not set. Use AvroJob.setInputKeySchema() if desired.");
            LOG.info("Using a key reader schema equal to the writer schema.");
        }
        if (null == (valueReaderSchema = AvroJob.getInputValueSchema(context.getConfiguration()))) {
            LOG.warn("Value reader schema was not set. Use AvroJob.setInputValueSchema() if desired.");
            LOG.info("Using a value reader schema equal to the writer schema.");
        }
        return new AvroKeyValueRecordReader(keyReaderSchema, valueReaderSchema);
    }
}

