/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common;

import com.facebook.presto.hive.$internal.org.slf4j.Logger;
import com.facebook.presto.hive.$internal.org.slf4j.LoggerFactory;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.List;

public final class JavaUtils {
    private static final Logger LOG = LoggerFactory.getLogger(JavaUtils.class);
    private static final Method SUN_MISC_UTIL_RELEASE;

    public static ClassLoader getClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = JavaUtils.class.getClassLoader();
        }
        return classLoader;
    }

    public static Class loadClass(String shadePrefix, String className) throws ClassNotFoundException {
        return JavaUtils.loadClass(shadePrefix + "." + className);
    }

    public static Class loadClass(String className) throws ClassNotFoundException {
        return JavaUtils.loadClass(className, true);
    }

    public static Class loadClass(String className, boolean init) throws ClassNotFoundException {
        return Class.forName(className, init, JavaUtils.getClassLoader());
    }

    public static boolean closeClassLoadersTo(ClassLoader current, ClassLoader stop) {
        if (!JavaUtils.isValidHierarchy(current, stop)) {
            return false;
        }
        while (current != null && current != stop) {
            try {
                JavaUtils.closeClassLoader(current);
            }
            catch (IOException e) {
                LOG.info("Failed to close class loader " + current + Arrays.toString(((URLClassLoader)current).getURLs()), e);
            }
            current = current.getParent();
        }
        return true;
    }

    private static boolean isValidHierarchy(ClassLoader current, ClassLoader stop) {
        if (current == null || stop == null || current == stop) {
            return false;
        }
        while (current != null && current != stop) {
            current = current.getParent();
        }
        return current == stop;
    }

    public static void closeClassLoader(ClassLoader loader) throws IOException {
        if (loader instanceof Closeable) {
            ((Closeable)((Object)loader)).close();
        } else if (SUN_MISC_UTIL_RELEASE != null && loader instanceof URLClassLoader) {
            PrintStream outputStream = System.out;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream newOutputStream = new PrintStream(byteArrayOutputStream);
            try {
                System.setOut(newOutputStream);
                SUN_MISC_UTIL_RELEASE.invoke(null, loader);
                String output = byteArrayOutputStream.toString("UTF8");
                LOG.debug(output);
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() instanceof IOException) {
                    throw (IOException)e.getTargetException();
                }
                throw new IOException(e.getTargetException());
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            finally {
                System.setOut(outputStream);
                newOutputStream.close();
            }
        }
    }

    public static String lockIdToString(long extLockId) {
        return "lockid:" + extLockId;
    }

    public static String txnIdToString(long txnId) {
        return "txnid:" + txnId;
    }

    public static String writeIdToString(long writeId) {
        return "writeid:" + writeId;
    }

    public static String txnIdsToString(List<Long> txnIds) {
        return "Transactions requested to be aborted: " + txnIds.toString();
    }

    private JavaUtils() {
    }

    static {
        if (Closeable.class.isAssignableFrom(URLClassLoader.class)) {
            SUN_MISC_UTIL_RELEASE = null;
        } else {
            Method release = null;
            try {
                Class<?> clazz = Class.forName("sun.misc.ClassLoaderUtil");
                release = clazz.getMethod("releaseLoader", URLClassLoader.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            SUN_MISC_UTIL_RELEASE = release;
        }
    }
}

