/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.messaging.json;

import com.facebook.presto.hive.$internal.org.codehaus.jackson.annotate.JsonProperty;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.messaging.CreateDatabaseMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONMessageDeserializer;
import org.apache.hadoop.hive.metastore.messaging.json.JSONMessageFactory;
import org.apache.thrift.TException;

public class JSONCreateDatabaseMessage
extends CreateDatabaseMessage {
    @JsonProperty
    String server;
    @JsonProperty
    String servicePrincipal;
    @JsonProperty
    String db;
    @JsonProperty
    String dbJson;
    @JsonProperty
    Long timestamp;

    public JSONCreateDatabaseMessage() {
    }

    public JSONCreateDatabaseMessage(String server, String servicePrincipal, Database db, Long timestamp) {
        this.server = server;
        this.servicePrincipal = servicePrincipal;
        this.db = db.getName();
        this.timestamp = timestamp;
        try {
            this.dbJson = JSONMessageFactory.createDatabaseObjJson(db);
        }
        catch (TException ex) {
            throw new IllegalArgumentException("Could not serialize Function object", ex);
        }
        this.checkValid();
    }

    @Override
    public Database getDatabaseObject() throws Exception {
        return (Database)JSONMessageFactory.getTObj(this.dbJson, Database.class);
    }

    @Override
    public String getDB() {
        return this.db;
    }

    @Override
    public String getServer() {
        return this.server;
    }

    @Override
    public String getServicePrincipal() {
        return this.servicePrincipal;
    }

    @Override
    public Long getTimestamp() {
        return this.timestamp;
    }

    public String toString() {
        try {
            return JSONMessageDeserializer.mapper.writeValueAsString(this);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Could not serialize: ", exception);
        }
    }
}

