/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.repl.bootstrap.load;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.events.DatabaseEvent;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.load.TaskTracker;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.load.util.Context;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.AlterDatabaseDesc;
import org.apache.hadoop.hive.ql.plan.CreateDatabaseDesc;
import org.apache.hadoop.hive.ql.plan.DDLWork;
import org.apache.hadoop.hive.ql.plan.PrincipalDesc;

public class LoadDatabase {
    final Context context;
    final TaskTracker tracker;
    private final DatabaseEvent event;
    private final String dbNameToLoadIn;

    public LoadDatabase(Context context, DatabaseEvent event, String dbNameToLoadIn, TaskTracker loadTaskTracker) {
        this.context = context;
        this.event = event;
        this.dbNameToLoadIn = dbNameToLoadIn;
        this.tracker = new TaskTracker(loadTaskTracker);
    }

    public TaskTracker tasks() throws SemanticException {
        try {
            Database dbInMetadata = this.readDbMetadata();
            Task<? extends Serializable> dbRootTask = this.existEmptyDb(dbInMetadata.getName()) ? LoadDatabase.alterDbTask(dbInMetadata, this.context.hiveConf) : this.createDbTask(dbInMetadata);
            dbRootTask.addDependentTask(this.setOwnerInfoTask(dbInMetadata));
            this.tracker.addTask(dbRootTask);
            return this.tracker;
        }
        catch (Exception e) {
            throw new SemanticException(e);
        }
    }

    Database readDbMetadata() throws SemanticException {
        return this.event.dbInMetadata(this.dbNameToLoadIn);
    }

    private Task<? extends Serializable> createDbTask(Database dbObj) {
        CreateDatabaseDesc createDbDesc = new CreateDatabaseDesc();
        createDbDesc.setName(dbObj.getName());
        createDbDesc.setComment(dbObj.getDescription());
        HashMap<String, String> parameters = new HashMap<String, String>(dbObj.getParameters());
        parameters.remove(ReplicationSpec.KEY.CURR_STATE_ID.toString());
        createDbDesc.setDatabaseProperties(parameters);
        createDbDesc.setIfNotExists(false);
        DDLWork work = new DDLWork(new HashSet<ReadEntity>(), new HashSet<WriteEntity>(), createDbDesc);
        return TaskFactory.get(work, this.context.hiveConf);
    }

    private static Task<? extends Serializable> alterDbTask(Database dbObj, HiveConf hiveConf) {
        AlterDatabaseDesc alterDbDesc = new AlterDatabaseDesc(dbObj.getName(), dbObj.getParameters(), null);
        DDLWork work = new DDLWork(new HashSet<ReadEntity>(), new HashSet<WriteEntity>(), alterDbDesc);
        return TaskFactory.get(work, hiveConf);
    }

    private Task<? extends Serializable> setOwnerInfoTask(Database dbObj) {
        AlterDatabaseDesc alterDbDesc = new AlterDatabaseDesc(dbObj.getName(), new PrincipalDesc(dbObj.getOwnerName(), dbObj.getOwnerType()), null);
        DDLWork work = new DDLWork(new HashSet<ReadEntity>(), new HashSet<WriteEntity>(), alterDbDesc);
        return TaskFactory.get(work, this.context.hiveConf);
    }

    private boolean existEmptyDb(String dbName) throws InvalidOperationException, HiveException {
        Database db = this.context.hiveDb.getDatabase(dbName);
        if (db == null) {
            return false;
        }
        List<String> allTables = this.context.hiveDb.getAllTables(dbName);
        List<String> allFunctions = this.context.hiveDb.getFunctions(dbName, "*");
        if (allTables.isEmpty() && allFunctions.isEmpty()) {
            return true;
        }
        throw new InvalidOperationException("Database " + db.getName() + " is not empty. One or more tables/functions exist.");
    }

    public static class AlterDatabase
    extends LoadDatabase {
        public AlterDatabase(Context context, DatabaseEvent event, String dbNameToLoadIn, TaskTracker loadTaskTracker) {
            super(context, event, dbNameToLoadIn, loadTaskTracker);
        }

        @Override
        public TaskTracker tasks() throws SemanticException {
            this.tracker.addTask(LoadDatabase.alterDbTask(this.readDbMetadata(), this.context.hiveConf));
            return this.tracker;
        }
    }
}

