/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.repl.bootstrap.load;

import com.facebook.presto.hive.$internal.org.slf4j.Logger;
import com.facebook.presto.hive.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.repl.ReplStateLogWork;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.AddDependencyToLeaves;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.events.FunctionEvent;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.load.TaskTracker;
import org.apache.hadoop.hive.ql.exec.repl.bootstrap.load.util.Context;
import org.apache.hadoop.hive.ql.exec.util.DAGTraversal;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.EximUtil;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.ReplLogger;
import org.apache.hadoop.hive.ql.parse.repl.load.message.CreateFunctionHandler;
import org.apache.hadoop.hive.ql.parse.repl.load.message.MessageHandler;

public class LoadFunction {
    private static final Logger LOG = LoggerFactory.getLogger(LoadFunction.class);
    private Context context;
    private ReplLogger replLogger;
    private final FunctionEvent event;
    private final String dbNameToLoadIn;
    private final TaskTracker tracker;

    public LoadFunction(Context context, ReplLogger replLogger, FunctionEvent event, String dbNameToLoadIn, TaskTracker existingTracker) {
        this.context = context;
        this.replLogger = replLogger;
        this.event = event;
        this.dbNameToLoadIn = dbNameToLoadIn;
        this.tracker = new TaskTracker(existingTracker);
    }

    private void createFunctionReplLogTask(List<Task<? extends Serializable>> functionTasks, String functionName) {
        ReplStateLogWork replLogWork = new ReplStateLogWork(this.replLogger, functionName);
        Task<ReplStateLogWork> replLogTask = TaskFactory.get(replLogWork);
        DAGTraversal.traverse(functionTasks, new AddDependencyToLeaves(replLogTask));
    }

    public TaskTracker tasks() throws IOException, SemanticException {
        URI fromURI = EximUtil.getValidatedURI(this.context.hiveConf, BaseSemanticAnalyzer.stripQuotes(this.event.rootDir().toUri().toString()));
        Path fromPath = new Path(fromURI.getScheme(), fromURI.getAuthority(), fromURI.getPath());
        try {
            CreateFunctionHandler handler = new CreateFunctionHandler();
            List<Task<? extends Serializable>> tasks = handler.handle(new MessageHandler.Context(this.dbNameToLoadIn, null, fromPath.toString(), null, null, this.context.hiveConf, this.context.hiveDb, this.context.nestedContext, LOG));
            this.createFunctionReplLogTask(tasks, handler.getFunctionName());
            tasks.forEach(this.tracker::addTask);
            return this.tracker;
        }
        catch (Exception e) {
            throw new SemanticException(ErrorMsg.INVALID_PATH.getMsg(), e);
        }
    }
}

