/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.metadata.formatting;

import com.facebook.presto.hive.$internal.org.apache.commons.lang.StringEscapeUtils;
import com.facebook.presto.hive.$internal.org.slf4j.Logger;
import com.facebook.presto.hive.$internal.org.slf4j.LoggerFactory;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.WMFullResourcePlan;
import org.apache.hadoop.hive.metastore.api.WMResourcePlan;
import org.apache.hadoop.hive.metastore.api.WMValidateResourcePlanResponse;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.ql.metadata.CheckConstraint;
import org.apache.hadoop.hive.ql.metadata.DefaultConstraint;
import org.apache.hadoop.hive.ql.metadata.ForeignKeyInfo;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.NotNullConstraint;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.PrimaryKeyInfo;
import org.apache.hadoop.hive.ql.metadata.StorageHandlerInfo;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.metadata.UniqueConstraint;
import org.apache.hadoop.hive.ql.metadata.formatting.MetaDataFormatUtils;
import org.apache.hadoop.hive.ql.metadata.formatting.MetaDataFormatter;
import org.apache.hadoop.hive.ql.metadata.formatting.TextMetaDataTable;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hive.common.util.HiveStringUtils;

class TextMetaDataFormatter
implements MetaDataFormatter {
    private static final Logger LOG = LoggerFactory.getLogger(TextMetaDataFormatter.class);
    private static final int separator = 9;
    private static final int terminator = 10;
    private final int prettyOutputNumCols;
    private final boolean showPartColsSeparately;
    private static final Charset UTF_8 = Charset.forName("UTF-8");

    public TextMetaDataFormatter(int prettyOutputNumCols, boolean partColsSeparately) {
        this.prettyOutputNumCols = prettyOutputNumCols;
        this.showPartColsSeparately = partColsSeparately;
    }

    @Override
    public void error(OutputStream out, String msg, int errorCode, String sqlState) throws HiveException {
        this.error(out, msg, errorCode, sqlState, null);
    }

    @Override
    public void error(OutputStream out, String errorMessage, int errorCode, String sqlState, String errorDetail) throws HiveException {
        try {
            out.write(errorMessage.getBytes("UTF-8"));
            if (errorDetail != null) {
                out.write(errorDetail.getBytes("UTF-8"));
            }
            out.write(errorCode);
            if (sqlState != null) {
                out.write(sqlState.getBytes("UTF-8"));
            }
            out.write(10);
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    @Override
    public void showTables(DataOutputStream out, Set<String> tables) throws HiveException {
        Iterator<String> iterTbls = tables.iterator();
        try {
            while (iterTbls.hasNext()) {
                out.write(iterTbls.next().getBytes("UTF-8"));
                out.write(10);
            }
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
    }

    @Override
    public void describeTable(DataOutputStream outStream, String colPath, String tableName, Table tbl, Partition part, List<FieldSchema> cols, boolean isFormatted, boolean isExt, boolean isOutputPadded, List<ColumnStatisticsObj> colStats, PrimaryKeyInfo pkInfo, ForeignKeyInfo fkInfo, UniqueConstraint ukInfo, NotNullConstraint nnInfo, DefaultConstraint dInfo, CheckConstraint cInfo, StorageHandlerInfo storageHandlerInfo) throws HiveException {
        try {
            String statsState;
            List<FieldSchema> partCols = tbl.isPartitioned() ? tbl.getPartCols() : null;
            String output = "";
            boolean isColStatsAvailable = colStats != null;
            TextMetaDataTable mdt = new TextMetaDataTable();
            if (isFormatted && !isColStatsAvailable) {
                output = "# ";
            }
            if (isFormatted) {
                mdt.addRow(MetaDataFormatUtils.getColumnsHeader(colStats));
            }
            for (FieldSchema col : cols) {
                mdt.addRow(MetaDataFormatUtils.extractColumnValues(col, isColStatsAvailable, MetaDataFormatUtils.getColumnStatisticsObject(col.getName(), col.getType(), colStats)));
            }
            if (isColStatsAvailable) {
                mdt.transpose();
            }
            output = output + mdt.renderTable(isOutputPadded);
            if (colPath.equals(tableName)) {
                if (partCols != null && !partCols.isEmpty() && this.showPartColsSeparately) {
                    mdt = new TextMetaDataTable();
                    output = output + "\n# Partition Information\n# ";
                    mdt.addRow(MetaDataFormatUtils.getColumnsHeader(null));
                    for (FieldSchema col : partCols) {
                        mdt.addRow(MetaDataFormatUtils.extractColumnValues(col));
                    }
                    output = output + mdt.renderTable(isOutputPadded);
                }
            } else if (tbl.getParameters() != null && (statsState = tbl.getParameters().get("COLUMN_STATS_ACCURATE")) != null) {
                StringBuilder str = new StringBuilder();
                MetaDataFormatUtils.formatOutput("COLUMN_STATS_ACCURATE", isFormatted ? StringEscapeUtils.escapeJava(statsState) : HiveStringUtils.escapeJava(statsState), str, isOutputPadded);
                output = output.concat(str.toString());
            }
            outStream.write(output.getBytes("UTF-8"));
            if (tableName.equals(colPath)) {
                if (isFormatted) {
                    output = part != null ? MetaDataFormatUtils.getPartitionInformation(part) : MetaDataFormatUtils.getTableInformation(tbl, isOutputPadded);
                    outStream.write(output.getBytes("UTF-8"));
                    if (pkInfo != null && !pkInfo.getColNames().isEmpty() || fkInfo != null && !fkInfo.getForeignKeys().isEmpty() || ukInfo != null && !ukInfo.getUniqueConstraints().isEmpty() || nnInfo != null && !nnInfo.getNotNullConstraints().isEmpty() || cInfo != null && !cInfo.getCheckConstraints().isEmpty() || dInfo != null && !dInfo.getDefaultConstraints().isEmpty()) {
                        output = MetaDataFormatUtils.getConstraintsInformation(pkInfo, fkInfo, ukInfo, nnInfo, dInfo, cInfo);
                        outStream.write(output.getBytes("UTF-8"));
                    }
                }
                if (isExt) {
                    outStream.write(10);
                    if (part != null) {
                        outStream.write("Detailed Partition Information".getBytes("UTF-8"));
                        outStream.write(9);
                        outStream.write(part.getTPartition().toString().getBytes("UTF-8"));
                        outStream.write(9);
                        outStream.write(10);
                    } else {
                        outStream.write("Detailed Table Information".getBytes("UTF-8"));
                        outStream.write(9);
                        String tableDesc = HiveStringUtils.escapeJava(tbl.getTTable().toString());
                        outStream.write(tableDesc.getBytes("UTF-8"));
                        outStream.write(9);
                        outStream.write(10);
                    }
                    if (pkInfo != null && !pkInfo.getColNames().isEmpty() || fkInfo != null && !fkInfo.getForeignKeys().isEmpty() || ukInfo != null && !ukInfo.getUniqueConstraints().isEmpty() || dInfo != null && !dInfo.getDefaultConstraints().isEmpty() || cInfo != null && !cInfo.getCheckConstraints().isEmpty() || nnInfo != null && !nnInfo.getNotNullConstraints().isEmpty()) {
                        outStream.write("Constraints".getBytes("UTF-8"));
                        outStream.write(9);
                        if (pkInfo != null && !pkInfo.getColNames().isEmpty()) {
                            outStream.write(pkInfo.toString().getBytes("UTF-8"));
                            outStream.write(10);
                        }
                        if (fkInfo != null && !fkInfo.getForeignKeys().isEmpty()) {
                            outStream.write(fkInfo.toString().getBytes("UTF-8"));
                            outStream.write(10);
                        }
                        if (ukInfo != null && !ukInfo.getUniqueConstraints().isEmpty()) {
                            outStream.write(ukInfo.toString().getBytes("UTF-8"));
                            outStream.write(10);
                        }
                        if (nnInfo != null && !nnInfo.getNotNullConstraints().isEmpty()) {
                            outStream.write(nnInfo.toString().getBytes("UTF-8"));
                            outStream.write(10);
                        }
                        if (dInfo != null && !dInfo.getDefaultConstraints().isEmpty()) {
                            outStream.write(dInfo.toString().getBytes("UTF-8"));
                            outStream.write(10);
                        }
                        if (cInfo != null && !cInfo.getCheckConstraints().isEmpty()) {
                            outStream.write(cInfo.toString().getBytes("UTF-8"));
                            outStream.write(10);
                        }
                    }
                    if (storageHandlerInfo != null) {
                        outStream.write("StorageHandlerInfo".getBytes("UTF-8"));
                        outStream.write(10);
                        outStream.write(storageHandlerInfo.formatAsText().getBytes("UTF-8"));
                        outStream.write(10);
                    }
                }
            }
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
    }

    @Override
    public void showTableStatus(DataOutputStream outStream, Hive db, HiveConf conf, List<Table> tbls, Map<String, String> part, Partition par) throws HiveException {
        try {
            for (Table tbl : tbls) {
                String tableName = tbl.getTableName();
                String tblLoc = null;
                String inputFormattCls = null;
                String outputFormattCls = null;
                if (part != null) {
                    if (par != null) {
                        if (par.getLocation() != null) {
                            tblLoc = par.getDataLocation().toString();
                        }
                        inputFormattCls = par.getInputFormatClass().getName();
                        outputFormattCls = par.getOutputFormatClass().getName();
                    }
                } else {
                    if (tbl.getPath() != null) {
                        tblLoc = tbl.getDataLocation().toString();
                    }
                    inputFormattCls = tbl.getInputFormatClass().getName();
                    outputFormattCls = tbl.getOutputFormatClass().getName();
                }
                String owner = tbl.getOwner();
                List<FieldSchema> cols = tbl.getCols();
                String ddlCols = MetaStoreUtils.getDDLFromFieldSchema("columns", cols);
                boolean isPartitioned = tbl.isPartitioned();
                String partitionCols = "";
                if (isPartitioned) {
                    partitionCols = MetaStoreUtils.getDDLFromFieldSchema("partition_columns", tbl.getPartCols());
                }
                outStream.write(("tableName:" + tableName).getBytes("UTF-8"));
                outStream.write(10);
                outStream.write(("owner:" + owner).getBytes("UTF-8"));
                outStream.write(10);
                outStream.write(("location:" + tblLoc).getBytes("UTF-8"));
                outStream.write(10);
                outStream.write(("inputformat:" + inputFormattCls).getBytes("UTF-8"));
                outStream.write(10);
                outStream.write(("outputformat:" + outputFormattCls).getBytes("UTF-8"));
                outStream.write(10);
                outStream.write(("columns:" + ddlCols).getBytes("UTF-8"));
                outStream.write(10);
                outStream.write(("partitioned:" + isPartitioned).getBytes("UTF-8"));
                outStream.write(10);
                outStream.write(("partitionColumns:" + partitionCols).getBytes("UTF-8"));
                outStream.write(10);
                Path tblPath = tbl.getPath();
                ArrayList<Path> locations = new ArrayList<Path>();
                if (isPartitioned) {
                    if (par == null) {
                        for (Partition curPart : db.getPartitions(tbl)) {
                            if (curPart.getLocation() == null) continue;
                            locations.add(new Path(curPart.getLocation()));
                        }
                    } else if (par.getLocation() != null) {
                        locations.add(new Path(par.getLocation()));
                    }
                } else if (tblPath != null) {
                    locations.add(tblPath);
                }
                if (!locations.isEmpty()) {
                    this.writeFileSystemStats(outStream, conf, locations, tblPath, false, 0);
                }
                outStream.write(10);
            }
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
    }

    private void writeFileSystemStats(DataOutputStream outStream, HiveConf conf, List<Path> locations, Path tblPath, boolean partSpecified, int indent) throws IOException {
        int k;
        FileData fd = new FileData();
        boolean unknown = false;
        FileSystem fs = tblPath.getFileSystem((Configuration)conf);
        try {
            FileStatus tmpStatus = fs.getFileStatus(tblPath);
            fd.lastAccessTime = tmpStatus.getAccessTime();
            fd.lastUpdateTime = tmpStatus.getModificationTime();
            if (partSpecified) {
                tmpStatus = fs.getFileStatus(locations.get(0));
            }
        }
        catch (IOException e) {
            LOG.warn("Cannot access File System. File System status will be unknown: ", e);
            unknown = true;
        }
        if (!unknown) {
            for (Path loc : locations) {
                try {
                    FileStatus status = fs.getFileStatus(loc);
                    if (!status.isDirectory()) continue;
                    this.processDir(status, fs, fd);
                }
                catch (IOException iOException) {}
            }
        }
        String unknownString = "unknown";
        for (k = 0; k < indent; ++k) {
            outStream.write("  ".getBytes("UTF-8"));
        }
        outStream.write("totalNumberFiles:".getBytes("UTF-8"));
        outStream.write((unknown ? unknownString : "" + fd.numOfFiles).getBytes("UTF-8"));
        outStream.write(10);
        for (k = 0; k < indent; ++k) {
            outStream.write("  ".getBytes("UTF-8"));
        }
        outStream.write("totalFileSize:".getBytes("UTF-8"));
        outStream.write((unknown ? unknownString : "" + fd.totalFileSize).getBytes("UTF-8"));
        outStream.write(10);
        for (k = 0; k < indent; ++k) {
            outStream.write("  ".getBytes("UTF-8"));
        }
        outStream.write("maxFileSize:".getBytes("UTF-8"));
        outStream.write((unknown ? unknownString : "" + fd.maxFileSize).getBytes("UTF-8"));
        outStream.write(10);
        for (k = 0; k < indent; ++k) {
            outStream.write("  ".getBytes("UTF-8"));
        }
        outStream.write("minFileSize:".getBytes("UTF-8"));
        if (fd.numOfFiles > 0) {
            outStream.write((unknown ? unknownString : "" + fd.minFileSize).getBytes("UTF-8"));
        } else {
            outStream.write((unknown ? unknownString : "0").getBytes("UTF-8"));
        }
        outStream.write(10);
        for (k = 0; k < indent; ++k) {
            outStream.write("  ".getBytes("UTF-8"));
        }
        outStream.write("lastAccessTime:".getBytes("UTF-8"));
        outStream.writeBytes(unknown || fd.lastAccessTime < 0L ? unknownString : "" + fd.lastAccessTime);
        outStream.write(10);
        for (k = 0; k < indent; ++k) {
            outStream.write("  ".getBytes("UTF-8"));
        }
        outStream.write("lastUpdateTime:".getBytes("UTF-8"));
        outStream.write((unknown ? unknownString : "" + fd.lastUpdateTime).getBytes("UTF-8"));
        outStream.write(10);
    }

    private void processDir(FileStatus status, FileSystem fs, FileData fd) throws IOException {
        FileStatus[] files;
        long accessTime = status.getAccessTime();
        long updateTime = status.getModificationTime();
        if (accessTime > fd.lastAccessTime) {
            fd.lastAccessTime = accessTime;
        }
        if (updateTime > fd.lastUpdateTime) {
            fd.lastUpdateTime = updateTime;
        }
        for (FileStatus currentStatus : files = fs.listStatus(status.getPath())) {
            if (currentStatus.isDirectory()) {
                this.processDir(currentStatus, fs, fd);
                continue;
            }
            ++fd.numOfFiles;
            long fileLen = currentStatus.getLen();
            fd.totalFileSize += fileLen;
            if (fileLen > fd.maxFileSize) {
                fd.maxFileSize = fileLen;
            }
            if (fileLen < fd.minFileSize) {
                fd.minFileSize = fileLen;
            }
            accessTime = currentStatus.getAccessTime();
            updateTime = currentStatus.getModificationTime();
            if (accessTime > fd.lastAccessTime) {
                fd.lastAccessTime = accessTime;
            }
            if (updateTime <= fd.lastUpdateTime) continue;
            fd.lastUpdateTime = updateTime;
        }
    }

    @Override
    public void showTablePartitions(DataOutputStream outStream, List<String> parts) throws HiveException {
        try {
            for (String part : parts) {
                SessionState ss = SessionState.get();
                if (ss != null && ss.getConf() != null && !ss.getConf().getBoolVar(HiveConf.ConfVars.HIVE_DECODE_PARTITION_NAME)) {
                    outStream.write(part.getBytes("UTF-8"));
                } else {
                    outStream.write(FileUtils.unescapePathName(part).getBytes("UTF-8"));
                }
                outStream.write(10);
            }
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
    }

    @Override
    public void showDatabases(DataOutputStream outStream, List<String> databases) throws HiveException {
        try {
            for (String database : databases) {
                outStream.write(database.getBytes("UTF-8"));
                outStream.write(10);
            }
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
    }

    @Override
    public void showDatabaseDescription(DataOutputStream outStream, String database, String comment, String location, String ownerName, String ownerType, Map<String, String> params) throws HiveException {
        try {
            outStream.write(database.getBytes("UTF-8"));
            outStream.write(9);
            if (comment != null) {
                outStream.write(HiveStringUtils.escapeJava(comment).getBytes("UTF-8"));
            }
            outStream.write(9);
            if (location != null) {
                outStream.write(location.getBytes("UTF-8"));
            }
            outStream.write(9);
            if (ownerName != null) {
                outStream.write(ownerName.getBytes("UTF-8"));
            }
            outStream.write(9);
            if (ownerType != null) {
                outStream.write(ownerType.getBytes("UTF-8"));
            }
            outStream.write(9);
            if (params != null && !params.isEmpty()) {
                outStream.write(params.toString().getBytes("UTF-8"));
            }
            outStream.write(10);
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
    }

    @Override
    public void showResourcePlans(DataOutputStream out, List<WMResourcePlan> resourcePlans) throws HiveException {
        try {
            for (WMResourcePlan plan : resourcePlans) {
                out.write(plan.getName().getBytes(UTF_8));
                out.write(9);
                out.write(plan.getStatus().name().getBytes(UTF_8));
                out.write(9);
                if (plan.isSetQueryParallelism()) {
                    out.write(Integer.toString(plan.getQueryParallelism()).getBytes(UTF_8));
                } else {
                    TextMetaDataFormatter.write(out, "null");
                }
                out.write(9);
                if (plan.isSetDefaultPoolPath()) {
                    out.write(plan.getDefaultPoolPath().getBytes(UTF_8));
                } else {
                    TextMetaDataFormatter.write(out, "null");
                }
                out.write(10);
            }
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
    }

    @Override
    public void showFullResourcePlan(DataOutputStream out, WMFullResourcePlan fullResourcePlan) throws HiveException {
        MetaDataFormatUtils.formatFullRP(new TextRPFormatter(out), fullResourcePlan);
    }

    private static byte[] str(String str) {
        return str.getBytes(UTF_8);
    }

    private static void write(DataOutputStream out, String val) throws IOException {
        out.write(TextMetaDataFormatter.str(val));
    }

    @Override
    public void showErrors(DataOutputStream out, WMValidateResourcePlanResponse response) throws HiveException {
        try {
            for (String error : response.getErrors()) {
                TextMetaDataFormatter.write(out, error);
                out.write(10);
            }
            for (String warning : response.getWarnings()) {
                TextMetaDataFormatter.write(out, "warn: ");
                TextMetaDataFormatter.write(out, warning);
                out.write(10);
            }
        }
        catch (IOException e) {
            throw new HiveException(e);
        }
    }

    static /* synthetic */ byte[] access$100(String x0) {
        return TextMetaDataFormatter.str(x0);
    }

    private static class TextRPFormatter
    implements MetaDataFormatUtils.RPFormatter {
        private static final byte[] INDENT = TextMetaDataFormatter.access$100("    ");
        private static final byte[] INDENT2 = TextMetaDataFormatter.access$100(" |  ");
        private static final byte[] INDENT_BRANCH = TextMetaDataFormatter.access$100(" +  ");
        private final DataOutputStream out;
        private int indentLevel = 0;

        TextRPFormatter(DataOutputStream out) {
            this.out = out;
        }

        @Override
        public void startRP(String rpName, Object ... kvPairs) throws IOException {
            TextMetaDataFormatter.write(this.out, rpName);
            this.writeFields(kvPairs);
            this.out.write(10);
        }

        @Override
        public void endRP() throws IOException {
        }

        @Override
        public void startPools() throws IOException {
        }

        @Override
        public void endPools() throws IOException {
        }

        @Override
        public void startPool(String poolName, Object ... kvPairs) throws IOException {
            ++this.indentLevel;
            this.writeIndent(true);
            TextMetaDataFormatter.write(this.out, poolName);
            this.writeFields(kvPairs);
            this.out.write(10);
        }

        @Override
        public void endPool() throws IOException {
            --this.indentLevel;
        }

        @Override
        public void startTriggers() throws IOException {
        }

        @Override
        public void startMappings() throws IOException {
        }

        @Override
        public void endTriggers() throws IOException {
        }

        @Override
        public void endMappings() throws IOException {
        }

        private void writeFields(Object ... kvPairs) throws IOException {
            if (kvPairs.length % 2 != 0) {
                throw new IllegalArgumentException("Expected pairs, got: " + kvPairs.length);
            }
            if (kvPairs.length < 2) {
                return;
            }
            this.out.write(91);
            this.out.write(kvPairs[0].toString().getBytes(UTF_8));
            this.out.write(61);
            this.out.write((kvPairs[1] == null ? "null" : kvPairs[1].toString()).getBytes(UTF_8));
            for (int i = 2; i < kvPairs.length; i += 2) {
                this.out.write(44);
                this.out.write(kvPairs[i].toString().getBytes(UTF_8));
                this.out.write(61);
                this.out.write((kvPairs[i + 1] == null ? "null" : kvPairs[i + 1].toString()).getBytes(UTF_8));
            }
            this.out.write(93);
        }

        @Override
        public void formatTrigger(String triggerName, String actionExpression, String triggerExpression) throws IOException {
            this.writeIndent(false);
            TextMetaDataFormatter.write(this.out, "trigger ");
            TextMetaDataFormatter.write(this.out, triggerName);
            TextMetaDataFormatter.write(this.out, ": if (");
            TextMetaDataFormatter.write(this.out, triggerExpression);
            TextMetaDataFormatter.write(this.out, ") { ");
            TextMetaDataFormatter.write(this.out, actionExpression);
            TextMetaDataFormatter.write(this.out, " }");
            this.out.write(10);
        }

        @Override
        public void formatMappingType(String type, List<String> names) throws IOException {
            int maxList = 5;
            this.writeIndent(false);
            TextMetaDataFormatter.write(this.out, "mapped for ");
            this.out.write(type.toLowerCase().getBytes(UTF_8));
            if (!names.isEmpty()) {
                TextMetaDataFormatter.write(this.out, "s: ");
                int count = Math.min(5, names.size());
                for (int i = 0; i < count; ++i) {
                    if (i != 0) {
                        TextMetaDataFormatter.write(this.out, ", ");
                    }
                    this.out.write(names.get(i).getBytes(UTF_8));
                }
                int remaining = names.size() - count;
                if (remaining > 0) {
                    this.out.write((" and " + remaining + " others").getBytes(UTF_8));
                }
            }
            this.out.write(10);
        }

        private void writeIndent(boolean isPool) throws IOException {
            for (int i = 0; i < this.indentLevel - 1; ++i) {
                this.out.write(INDENT);
            }
            if (isPool) {
                this.out.write(INDENT_BRANCH);
            } else {
                this.out.write(INDENT);
                this.out.write(INDENT2);
            }
        }
    }

    private static class FileData {
        public long totalFileSize = 0L;
        public long maxFileSize = 0L;
        public long minFileSize = Long.MAX_VALUE;
        public long lastAccessTime = 0L;
        public long lastUpdateTime = 0L;
        public int numOfFiles = 0;

        private FileData() {
        }
    }
}

