/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security.authorization.plugin;

import com.facebook.presto.hive.$internal.com.google.common.collect.ComparisonChain;
import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.common.classification.InterfaceStability;
import org.apache.hadoop.hive.metastore.api.RolePrincipalGrant;

@InterfaceAudience.LimitedPrivate(value={"Apache Argus (incubating)"})
@InterfaceStability.Evolving
public class HiveRoleGrant
implements Comparable<HiveRoleGrant> {
    private String roleName;
    private String principalName;
    private String principalType;
    private boolean grantOption;
    private int grantTime;
    private String grantor;
    private String grantorType;

    public HiveRoleGrant() {
    }

    public HiveRoleGrant(RolePrincipalGrant thriftRoleGrant) {
        this.roleName = thriftRoleGrant.getRoleName();
        this.principalName = thriftRoleGrant.getPrincipalName();
        this.principalType = thriftRoleGrant.getPrincipalType().name();
        this.grantOption = thriftRoleGrant.isGrantOption();
        this.grantTime = thriftRoleGrant.getGrantTime();
        this.grantor = thriftRoleGrant.getGrantorName();
        this.grantorType = thriftRoleGrant.getGrantorPrincipalType() == null ? null : thriftRoleGrant.getGrantorPrincipalType().name();
    }

    public String getRoleName() {
        return this.roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public String getPrincipalName() {
        return this.principalName;
    }

    public void setPrincipalName(String principalName) {
        this.principalName = principalName;
    }

    public String getPrincipalType() {
        return this.principalType;
    }

    public void setPrincipalType(String principalType) {
        this.principalType = principalType;
    }

    public boolean isGrantOption() {
        return this.grantOption;
    }

    public void setGrantOption(boolean grantOption) {
        this.grantOption = grantOption;
    }

    public int getGrantTime() {
        return this.grantTime;
    }

    public void setGrantTime(int grantTime) {
        this.grantTime = grantTime;
    }

    public String getGrantor() {
        return this.grantor;
    }

    public void setGrantor(String grantor) {
        this.grantor = grantor;
    }

    public String getGrantorType() {
        return this.grantorType;
    }

    public void setGrantorType(String grantorType) {
        this.grantorType = grantorType;
    }

    @Override
    public int compareTo(HiveRoleGrant other) {
        if (other == null) {
            return 1;
        }
        return ComparisonChain.start().compare((Comparable<?>)((Object)this.roleName), (Comparable<?>)((Object)other.roleName)).compare((Comparable<?>)((Object)this.principalName), (Comparable<?>)((Object)other.principalName)).compare((Comparable<?>)((Object)this.principalType), (Comparable<?>)((Object)other.principalType)).compare(this.grantOption, other.grantOption).compare(this.grantTime, other.grantTime).compare((Comparable<?>)((Object)this.grantor), (Comparable<?>)((Object)other.grantor)).result();
    }

    public String toString() {
        return this.roleName + "[" + this.principalName + ":" + this.principalType + (this.grantOption ? ":WITH GRANT]" : "]");
    }
}

