/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.sql.tree.DefaultTraversalVisitor;
import com.facebook.presto.sql.tree.LambdaArgumentDeclaration;
import com.facebook.presto.sql.tree.LambdaExpression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.Parameter;
import com.facebook.presto.sql.tree.Statement;
import java.util.ArrayList;
import java.util.List;

public class ParameterExtractor {
    private ParameterExtractor() {
    }

    public static int getParameterCount(Statement statement) {
        ParameterExtractingVisitor parameterExtractingVisitor = new ParameterExtractingVisitor();
        parameterExtractingVisitor.process((Node)statement, null);
        return parameterExtractingVisitor.getParameters().size();
    }

    public static List<Parameter> getParameters(Statement statement) {
        ParameterExtractingVisitor parameterExtractingVisitor = new ParameterExtractingVisitor();
        parameterExtractingVisitor.process((Node)statement, null);
        return parameterExtractingVisitor.getParameters();
    }

    private static class ParameterExtractingVisitor
    extends DefaultTraversalVisitor<Void, Void> {
        private final List<Parameter> parameters = new ArrayList<Parameter>();

        private ParameterExtractingVisitor() {
        }

        public List<Parameter> getParameters() {
            return this.parameters;
        }

        public Void visitParameter(Parameter node, Void context) {
            this.parameters.add(node);
            return null;
        }

        protected Void visitLambdaExpression(LambdaExpression node, Void context) {
            this.process((Node)node.getBody(), context);
            for (LambdaArgumentDeclaration argument : node.getArguments()) {
                this.process((Node)argument, context);
            }
            return null;
        }
    }
}

