/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.airlift.stats.CounterStat;
import java.util.Objects;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public final class SqlTaskIoStats {
    private final CounterStat inputDataSize;
    private final CounterStat inputPositions;
    private final CounterStat outputDataSize;
    private final CounterStat outputPositions;

    public SqlTaskIoStats() {
        this(new CounterStat(), new CounterStat(), new CounterStat(), new CounterStat());
    }

    public SqlTaskIoStats(CounterStat inputDataSize, CounterStat inputPositions, CounterStat outputDataSize, CounterStat outputPositions) {
        this.inputDataSize = Objects.requireNonNull(inputDataSize, "inputDataSize is null");
        this.inputPositions = Objects.requireNonNull(inputPositions, "inputPositions is null");
        this.outputDataSize = Objects.requireNonNull(outputDataSize, "outputDataSize is null");
        this.outputPositions = Objects.requireNonNull(outputPositions, "outputPositions is null");
    }

    @Managed
    @Nested
    public CounterStat getInputDataSize() {
        return this.inputDataSize;
    }

    @Managed
    @Nested
    public CounterStat getInputPositions() {
        return this.inputPositions;
    }

    @Managed
    @Nested
    public CounterStat getOutputDataSize() {
        return this.outputDataSize;
    }

    @Managed
    @Nested
    public CounterStat getOutputPositions() {
        return this.outputPositions;
    }

    public void merge(SqlTaskIoStats ioStats) {
        this.inputDataSize.merge(ioStats.inputDataSize);
        this.inputPositions.merge(ioStats.inputPositions);
        this.outputDataSize.merge(ioStats.outputDataSize);
        this.outputPositions.merge(ioStats.outputPositions);
    }

    public void resetTo(SqlTaskIoStats ioStats) {
        this.inputDataSize.resetTo(ioStats.inputDataSize);
        this.inputPositions.resetTo(ioStats.inputPositions);
        this.outputDataSize.resetTo(ioStats.outputDataSize);
        this.outputPositions.resetTo(ioStats.outputPositions);
    }
}

