/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.buffer;

import com.facebook.drift.annotations.ThriftConstructor;
import com.facebook.drift.annotations.ThriftField;
import com.facebook.drift.annotations.ThriftStruct;
import com.facebook.presto.execution.buffer.OutputBuffers;
import com.facebook.presto.execution.buffer.PageBufferInfo;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;

@ThriftStruct
public class BufferInfo {
    private final OutputBuffers.OutputBufferId bufferId;
    private final boolean finished;
    private final int bufferedPages;
    private final long pagesSent;
    private final PageBufferInfo pageBufferInfo;

    @JsonCreator
    @ThriftConstructor
    public BufferInfo(@JsonProperty(value="bufferId") OutputBuffers.OutputBufferId bufferId, @JsonProperty(value="finished") boolean finished, @JsonProperty(value="bufferedPages") int bufferedPages, @JsonProperty(value="pagesSent") long pagesSent, @JsonProperty(value="pageBufferInfo") PageBufferInfo pageBufferInfo) {
        Preconditions.checkArgument((bufferedPages >= 0 ? 1 : 0) != 0, (Object)"bufferedPages must be >= 0");
        Preconditions.checkArgument((pagesSent >= 0L ? 1 : 0) != 0, (Object)"pagesSent must be >= 0");
        this.bufferId = Objects.requireNonNull(bufferId, "bufferId is null");
        this.pagesSent = pagesSent;
        this.pageBufferInfo = Objects.requireNonNull(pageBufferInfo, "pageBufferInfo is null");
        this.finished = finished;
        this.bufferedPages = bufferedPages;
    }

    @JsonProperty
    @ThriftField(value=1)
    public OutputBuffers.OutputBufferId getBufferId() {
        return this.bufferId;
    }

    @JsonProperty
    @ThriftField(value=2)
    public boolean isFinished() {
        return this.finished;
    }

    @JsonProperty
    @ThriftField(value=3)
    public int getBufferedPages() {
        return this.bufferedPages;
    }

    @JsonProperty
    @ThriftField(value=4)
    public long getPagesSent() {
        return this.pagesSent;
    }

    @JsonProperty
    @ThriftField(value=5)
    public PageBufferInfo getPageBufferInfo() {
        return this.pageBufferInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BufferInfo that = (BufferInfo)o;
        return Objects.equals(this.finished, that.finished) && Objects.equals(this.bufferedPages, that.bufferedPages) && Objects.equals(this.pagesSent, that.pagesSent) && Objects.equals(this.bufferId, that.bufferId) && Objects.equals(this.pageBufferInfo, that.pageBufferInfo);
    }

    public int hashCode() {
        return Objects.hash(this.bufferId, this.finished, this.bufferedPages, this.pagesSent, this.pageBufferInfo);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("bufferId", (Object)this.bufferId).add("finished", this.finished).add("bufferedPages", this.bufferedPages).add("pagesSent", this.pagesSent).add("pageBufferInfo", (Object)this.pageBufferInfo).toString();
    }
}

