/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.buffer;

import com.facebook.drift.annotations.ThriftEnum;
import com.facebook.drift.annotations.ThriftEnumValue;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.stream.Stream;

@ThriftEnum
public enum BufferState {
    OPEN(true, true, false, 0),
    NO_MORE_BUFFERS(true, false, false, 1),
    NO_MORE_PAGES(false, true, false, 2),
    FLUSHING(false, false, false, 3),
    FINISHED(false, false, true, 4),
    FAILED(false, false, true, 5);

    public static final Set<BufferState> TERMINAL_BUFFER_STATES;
    private final boolean newPagesAllowed;
    private final boolean newBuffersAllowed;
    private final boolean terminal;
    private final int value;

    private BufferState(boolean newPagesAllowed, boolean newBuffersAllowed, boolean terminal, int value) {
        this.newPagesAllowed = newPagesAllowed;
        this.newBuffersAllowed = newBuffersAllowed;
        this.terminal = terminal;
        this.value = value;
    }

    public boolean canAddPages() {
        return this.newPagesAllowed;
    }

    public boolean canAddBuffers() {
        return this.newBuffersAllowed;
    }

    public boolean isTerminal() {
        return this.terminal;
    }

    @ThriftEnumValue
    public int getValue() {
        return this.value;
    }

    static {
        TERMINAL_BUFFER_STATES = (Set)Stream.of(BufferState.values()).filter(BufferState::isTerminal).collect(ImmutableSet.toImmutableSet());
    }
}

