/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.buffer;

import com.facebook.airlift.concurrent.Threads;
import com.facebook.presto.execution.StateMachine;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.buffer.BufferState;
import com.facebook.presto.execution.buffer.OutputBuffers;
import com.facebook.presto.execution.buffer.SpoolingOutputBuffer;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.storage.TempStorageManager;
import com.facebook.presto.testing.TestingTempStorageManager;
import com.facebook.presto.util.FinalizerService;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.io.Closer;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;

public class SpoolingOutputBufferFactory {
    private ListeningExecutorService executor;
    private final FeaturesConfig featuresConfig;
    private final TempStorageManager tempStorageManager;
    private final FinalizerService finalizerService;
    private final Closer closer = Closer.create();
    private final ExecutorService coreExecutor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"spooling-outputbuffer-%s"));

    @Inject
    public SpoolingOutputBufferFactory(FeaturesConfig featuresConfig, TempStorageManager tempStorageManager, FinalizerService finalizerService) {
        this.featuresConfig = Objects.requireNonNull(featuresConfig, "featuresConfig is null");
        this.tempStorageManager = Objects.requireNonNull(tempStorageManager, "tempStorageManger is null");
        this.finalizerService = Objects.requireNonNull(finalizerService, "finalizerService is null");
    }

    @VisibleForTesting
    public SpoolingOutputBufferFactory(FeaturesConfig featuresConfig) {
        this.featuresConfig = Objects.requireNonNull(featuresConfig);
        this.tempStorageManager = new TestingTempStorageManager();
        this.finalizerService = new FinalizerService();
        this.initialize();
    }

    @PostConstruct
    public void initialize() {
        this.closer.register(this.coreExecutor::shutdownNow);
        this.executor = MoreExecutors.listeningDecorator((ExecutorService)this.coreExecutor);
    }

    @PreDestroy
    public void shutdown() throws IOException {
        this.closer.close();
    }

    public SpoolingOutputBuffer createSpoolingOutputBuffer(TaskId taskId, String taskInstanceId, OutputBuffers outputBuffers, StateMachine<BufferState> state) {
        return new SpoolingOutputBuffer(taskId, taskInstanceId, outputBuffers, state, this.tempStorageManager.getTempStorage("local"), this.featuresConfig.getSpoolingOutputBufferThreshold(), this.executor, this.finalizerService);
    }
}

