/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.scheduler;

import com.facebook.presto.metadata.InternalNode;
import com.facebook.presto.metadata.Split;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.ToIntFunction;

public abstract class BucketNodeMap {
    private final ToIntFunction<Split> splitToBucket;

    public BucketNodeMap(ToIntFunction<Split> splitToBucket) {
        this.splitToBucket = Objects.requireNonNull(splitToBucket, "splitToBucket is null");
    }

    public abstract int getBucketCount();

    public abstract Optional<InternalNode> getAssignedNode(int var1);

    public abstract boolean isBucketCacheable(int var1);

    public abstract void assignOrUpdateBucketToNode(int var1, InternalNode var2, boolean var3);

    public abstract boolean isDynamic();

    public abstract boolean hasInitialMap();

    public final Optional<InternalNode> getAssignedNode(Split split) {
        return this.getAssignedNode(this.splitToBucket.applyAsInt(split));
    }

    public final boolean isSplitCacheable(Split split) {
        return this.isBucketCacheable(this.splitToBucket.applyAsInt(split));
    }

    public abstract Optional<List<InternalNode>> getBucketToNode();
}

