/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.scheduler;

import com.facebook.presto.common.type.encoding.StringUtils;
import com.facebook.presto.metadata.InternalNode;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.NodeProvider;
import com.google.common.collect.ImmutableList;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.TreeMap;

public class ConsistentHashingNodeProvider
implements NodeProvider {
    private static final HashFunction HASH_FUNCTION = Hashing.murmur3_32();
    private final NavigableMap<Integer, InternalNode> candidates;
    private final int nodeCount;

    static ConsistentHashingNodeProvider create(Collection<InternalNode> nodes, int weight) {
        TreeMap<Integer, InternalNode> activeNodesByConsistentHashing = new TreeMap<Integer, InternalNode>();
        for (InternalNode node : nodes) {
            for (int i = 0; i < weight; ++i) {
                activeNodesByConsistentHashing.put(Hashing.murmur3_32().hashString((CharSequence)String.format("%s%d", node.getNodeIdentifier(), i), StringUtils.UTF_8).asInt(), node);
            }
        }
        return new ConsistentHashingNodeProvider(activeNodesByConsistentHashing, nodes.size());
    }

    private ConsistentHashingNodeProvider(NavigableMap<Integer, InternalNode> candidates, int nodeCount) {
        this.candidates = Objects.requireNonNull(candidates, "candidates is null");
        this.nodeCount = nodeCount;
    }

    public List<HostAddress> get(String key, int count) {
        NavigableMap<Integer, InternalNode> nextEntries;
        HostAddress candidate;
        if (count > this.nodeCount) {
            count = this.nodeCount;
        }
        ImmutableList.Builder nodes = ImmutableList.builder();
        HashSet<HostAddress> unique = new HashSet<HostAddress>();
        int hashKey = HASH_FUNCTION.hashString((CharSequence)String.format("%s", key), StringUtils.UTF_8).asInt();
        Map.Entry<Integer, InternalNode> entry = this.candidates.ceilingEntry(hashKey);
        if (entry != null) {
            candidate = entry.getValue().getHostAndPort();
            nextEntries = this.candidates.tailMap(entry.getKey(), false);
        } else {
            candidate = this.candidates.firstEntry().getValue().getHostAndPort();
            nextEntries = this.candidates.tailMap((Integer)this.candidates.firstKey(), false);
        }
        unique.add(candidate);
        nodes.add((Object)candidate);
        while (unique.size() < count) {
            for (Map.Entry next : nextEntries.entrySet()) {
                candidate = ((InternalNode)next.getValue()).getHostAndPort();
                if (unique.contains(candidate)) continue;
                unique.add(candidate);
                nodes.add((Object)candidate);
                if (unique.size() != count) continue;
                break;
            }
            nextEntries = this.candidates;
        }
        return nodes.build();
    }
}

