/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.scheduler.nodeSelection;

import com.facebook.presto.execution.scheduler.NodeScheduler;
import com.facebook.presto.execution.scheduler.ResettableRandomizedIterator;
import com.facebook.presto.execution.scheduler.nodeSelection.NodeSelection;
import com.facebook.presto.metadata.InternalNode;
import com.facebook.presto.metadata.Split;
import java.util.List;
import java.util.Objects;

public class RandomNodeSelection
implements NodeSelection {
    private final int minCandidates;
    private final ResettableRandomizedIterator<InternalNode> randomCandidates;

    public RandomNodeSelection(List<InternalNode> eligibleNodes, int minCandidates) {
        Objects.requireNonNull(eligibleNodes, "eligibleNodes is null");
        this.randomCandidates = new ResettableRandomizedIterator<InternalNode>(eligibleNodes);
        this.minCandidates = minCandidates;
    }

    @Override
    public List<InternalNode> pickNodes(Split split) {
        this.randomCandidates.reset();
        return NodeScheduler.selectNodes(this.minCandidates, this.randomCandidates);
    }
}

