/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.memory;

import com.facebook.presto.execution.TaskId;
import com.facebook.presto.memory.MemoryPoolListener;
import com.facebook.presto.memory.TaskRevocableMemoryListener;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.memory.MemoryAllocation;
import com.facebook.presto.spi.memory.MemoryPoolId;
import com.facebook.presto.spi.memory.MemoryPoolInfo;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.units.DataSize;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.weakref.jmx.Managed;

public class MemoryPool {
    private static final String MOVE_QUERY_TAG = "MOVE_QUERY_OPERATION";
    private final MemoryPoolId id;
    private final long maxBytes;
    @GuardedBy(value="this")
    private long reservedBytes;
    @GuardedBy(value="this")
    private long reservedRevocableBytes;
    @Nullable
    @GuardedBy(value="this")
    private NonCancellableMemoryFuture<?> future;
    @GuardedBy(value="this")
    private final Map<QueryId, Long> queryMemoryReservations = new HashMap<QueryId, Long>();
    @GuardedBy(value="this")
    private final Map<QueryId, Map<String, Long>> taggedMemoryAllocations = new HashMap<QueryId, Map<String, Long>>();
    @GuardedBy(value="this")
    private final Map<QueryId, Long> queryMemoryRevocableReservations = new HashMap<QueryId, Long>();
    private final List<MemoryPoolListener> listeners = new CopyOnWriteArrayList<MemoryPoolListener>();
    private final List<TaskRevocableMemoryListener> taskRevocableMemoryListeners = new CopyOnWriteArrayList<TaskRevocableMemoryListener>();

    public MemoryPool(MemoryPoolId id, DataSize size) {
        this.id = Objects.requireNonNull(id, "name is null");
        Objects.requireNonNull(size, "size is null");
        this.maxBytes = size.toBytes();
    }

    public MemoryPoolId getId() {
        return this.id;
    }

    public synchronized MemoryPoolInfo getInfo() {
        HashMap memoryAllocations = new HashMap();
        for (Map.Entry<QueryId, Map<String, Long>> entry : this.taggedMemoryAllocations.entrySet()) {
            ArrayList allocations = new ArrayList();
            if (entry.getValue() != null) {
                entry.getValue().forEach((tag, allocation) -> allocations.add(new MemoryAllocation(tag, allocation.longValue())));
            }
            memoryAllocations.put(entry.getKey(), allocations);
        }
        return new MemoryPoolInfo(this.maxBytes, this.reservedBytes, this.reservedRevocableBytes, this.queryMemoryReservations, memoryAllocations, this.queryMemoryRevocableReservations);
    }

    public void addListener(MemoryPoolListener listener) {
        this.listeners.add(Objects.requireNonNull(listener, "listener cannot be null"));
    }

    public void removeListener(MemoryPoolListener listener) {
        this.listeners.remove(Objects.requireNonNull(listener, "listener cannot be null"));
    }

    public void addTaskRevocableMemoryListener(TaskRevocableMemoryListener listener) {
        this.taskRevocableMemoryListeners.add(Objects.requireNonNull(listener, "listener cannot be null"));
    }

    public void removeTaskRevocableMemoryListener(TaskRevocableMemoryListener listener) {
        this.taskRevocableMemoryListeners.remove(Objects.requireNonNull(listener, "listener cannot be null"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<?> reserve(QueryId queryId, String allocationTag, long bytes) {
        Object result;
        Preconditions.checkArgument((bytes >= 0L ? 1 : 0) != 0, (Object)"bytes is negative");
        MemoryPool memoryPool = this;
        synchronized (memoryPool) {
            if (bytes != 0L) {
                this.queryMemoryReservations.merge(queryId, bytes, Long::sum);
                this.updateTaggedMemoryAllocations(queryId, allocationTag, bytes);
            }
            this.reservedBytes += bytes;
            if (this.getFreeBytes() <= 0L) {
                if (this.future == null) {
                    this.future = NonCancellableMemoryFuture.create();
                }
                Preconditions.checkState((!this.future.isDone() ? 1 : 0) != 0, (Object)"future is already completed");
                result = this.future;
            } else {
                result = Operator.NOT_BLOCKED;
            }
        }
        this.onMemoryReserved(queryId);
        return result;
    }

    private void onMemoryReserved(QueryId queryId) {
        long totalMemoryReservation = this.queryMemoryReservations.getOrDefault(queryId, 0L) + this.queryMemoryRevocableReservations.getOrDefault(queryId, 0L);
        this.listeners.forEach(listener -> listener.onMemoryReserved(this, queryId, totalMemoryReservation));
    }

    public void onTaskRevocableMemoryReserved(TaskId taskId) {
        this.taskRevocableMemoryListeners.forEach(listener -> listener.onMemoryReserved(taskId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<?> reserveRevocable(QueryId queryId, long bytes) {
        Object result;
        Preconditions.checkArgument((bytes >= 0L ? 1 : 0) != 0, (Object)"bytes is negative");
        MemoryPool memoryPool = this;
        synchronized (memoryPool) {
            if (bytes != 0L) {
                this.queryMemoryRevocableReservations.merge(queryId, bytes, Long::sum);
            }
            this.reservedRevocableBytes += bytes;
            if (this.getFreeBytes() <= 0L) {
                if (this.future == null) {
                    this.future = NonCancellableMemoryFuture.create();
                }
                Preconditions.checkState((!this.future.isDone() ? 1 : 0) != 0, (Object)"future is already completed");
                result = this.future;
            } else {
                result = Operator.NOT_BLOCKED;
            }
        }
        this.onMemoryReserved(queryId);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryReserve(QueryId queryId, String allocationTag, long bytes) {
        Preconditions.checkArgument((bytes >= 0L ? 1 : 0) != 0, (Object)"bytes is negative");
        MemoryPool memoryPool = this;
        synchronized (memoryPool) {
            if (this.getFreeBytes() - bytes < 0L) {
                return false;
            }
            this.reservedBytes += bytes;
            if (bytes != 0L) {
                this.queryMemoryReservations.merge(queryId, bytes, Long::sum);
                this.updateTaggedMemoryAllocations(queryId, allocationTag, bytes);
            }
        }
        this.onMemoryReserved(queryId);
        return true;
    }

    public synchronized void free(QueryId queryId, String allocationTag, long bytes) {
        Preconditions.checkArgument((bytes >= 0L ? 1 : 0) != 0, (Object)"bytes is negative");
        Preconditions.checkArgument((this.reservedBytes >= bytes ? 1 : 0) != 0, (Object)"tried to free more memory than is reserved");
        if (bytes == 0L) {
            return;
        }
        Long queryReservation = this.queryMemoryReservations.get(queryId);
        Objects.requireNonNull(queryReservation, "queryReservation is null");
        Preconditions.checkArgument((queryReservation - bytes >= 0L ? 1 : 0) != 0, (Object)"tried to free more memory than is reserved by query");
        queryReservation = queryReservation - bytes;
        if (queryReservation == 0L) {
            this.queryMemoryReservations.remove(queryId);
            this.taggedMemoryAllocations.remove(queryId);
        } else {
            this.queryMemoryReservations.put(queryId, queryReservation);
            this.updateTaggedMemoryAllocations(queryId, allocationTag, -bytes);
        }
        this.reservedBytes -= bytes;
        if (this.getFreeBytes() > 0L && this.future != null) {
            this.future.set(null);
            this.future = null;
        }
    }

    public synchronized void freeRevocable(QueryId queryId, long bytes) {
        Preconditions.checkArgument((bytes >= 0L ? 1 : 0) != 0, (Object)"bytes is negative");
        Preconditions.checkArgument((this.reservedRevocableBytes >= bytes ? 1 : 0) != 0, (Object)"tried to free more revocable memory than is reserved");
        if (bytes == 0L) {
            return;
        }
        Long queryReservation = this.queryMemoryRevocableReservations.get(queryId);
        Objects.requireNonNull(queryReservation, "queryReservation is null");
        Preconditions.checkArgument((queryReservation - bytes >= 0L ? 1 : 0) != 0, (Object)"tried to free more revocable memory than is reserved by query");
        queryReservation = queryReservation - bytes;
        if (queryReservation == 0L) {
            this.queryMemoryRevocableReservations.remove(queryId);
        } else {
            this.queryMemoryRevocableReservations.put(queryId, queryReservation);
        }
        this.reservedRevocableBytes -= bytes;
        if (this.getFreeBytes() > 0L && this.future != null) {
            this.future.set(null);
            this.future = null;
        }
    }

    synchronized ListenableFuture<?> moveQuery(QueryId queryId, MemoryPool targetMemoryPool) {
        long originalReserved = this.getQueryMemoryReservation(queryId);
        long originalRevocableReserved = this.getQueryRevocableMemoryReservation(queryId);
        Map<String, Long> taggedAllocations = this.taggedMemoryAllocations.remove(queryId);
        ListenableFuture<?> future = targetMemoryPool.reserve(queryId, MOVE_QUERY_TAG, originalReserved);
        this.free(queryId, MOVE_QUERY_TAG, originalReserved);
        targetMemoryPool.reserveRevocable(queryId, originalRevocableReserved);
        this.freeRevocable(queryId, originalRevocableReserved);
        targetMemoryPool.taggedMemoryAllocations.put(queryId, taggedAllocations);
        return future;
    }

    @Managed
    public synchronized long getFreeBytes() {
        return this.maxBytes - this.reservedBytes - this.reservedRevocableBytes;
    }

    @Managed
    public long getMaxBytes() {
        return this.maxBytes;
    }

    @Managed
    public synchronized long getReservedBytes() {
        return this.reservedBytes;
    }

    @Managed
    public synchronized long getReservedRevocableBytes() {
        return this.reservedRevocableBytes;
    }

    public synchronized long getQueryMemoryReservation(QueryId queryId) {
        return this.queryMemoryReservations.getOrDefault(queryId, 0L);
    }

    public synchronized long getQueryRevocableMemoryReservation(QueryId queryId) {
        return this.queryMemoryRevocableReservations.getOrDefault(queryId, 0L);
    }

    public synchronized String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("maxBytes", this.maxBytes).add("freeBytes", this.getFreeBytes()).add("reservedBytes", this.reservedBytes).add("reservedRevocableBytes", this.reservedRevocableBytes).add("future", this.future).toString();
    }

    private synchronized void updateTaggedMemoryAllocations(QueryId queryId, String allocationTag, long delta) {
        if (delta == 0L) {
            return;
        }
        Map allocations = this.taggedMemoryAllocations.computeIfAbsent(queryId, ignored -> new HashMap());
        allocations.compute(allocationTag, (ignored, oldValue) -> {
            if (oldValue == null) {
                return delta;
            }
            long newValue = oldValue + delta;
            if (newValue == 0L) {
                return null;
            }
            return newValue;
        });
    }

    @VisibleForTesting
    synchronized Map<QueryId, Map<String, Long>> getTaggedMemoryAllocations() {
        return (Map)this.taggedMemoryAllocations.keySet().stream().collect(ImmutableMap.toImmutableMap(Function.identity(), this::getTaggedMemoryAllocations));
    }

    @VisibleForTesting
    synchronized Map<String, Long> getTaggedMemoryAllocations(QueryId targetQueryId) {
        if (this.taggedMemoryAllocations.get(targetQueryId) == null) {
            return null;
        }
        return (Map)this.taggedMemoryAllocations.get(targetQueryId).entrySet().stream().filter(entry -> !((String)entry.getKey()).equals("FORCE_FREE_OPERATION")).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static class NonCancellableMemoryFuture<V>
    extends AbstractFuture<V> {
        private NonCancellableMemoryFuture() {
        }

        public static <V> NonCancellableMemoryFuture<V> create() {
            return new NonCancellableMemoryFuture<V>();
        }

        public boolean set(@Nullable V value) {
            return super.set(value);
        }

        public boolean cancel(boolean mayInterruptIfRunning) {
            throw new UnsupportedOperationException("cancellation is not supported");
        }
    }
}

