/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.common.CatalogSchemaName;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.metadata.BuiltInTypeAndFunctionNamespaceManager;

public enum CastType {
    CAST(OperatorType.CAST.getFunctionName(), true),
    SATURATED_FLOOR_CAST(OperatorType.SATURATED_FLOOR_CAST.getFunctionName(), true),
    TRY_CAST(QualifiedObjectName.valueOf((CatalogSchemaName)BuiltInTypeAndFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)"TRY_CAST"), false),
    JSON_TO_ARRAY_CAST(QualifiedObjectName.valueOf((CatalogSchemaName)BuiltInTypeAndFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)"$internal$json_string_to_array_cast"), false),
    JSON_TO_MAP_CAST(QualifiedObjectName.valueOf((CatalogSchemaName)BuiltInTypeAndFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)"$internal$json_string_to_map_cast"), false),
    JSON_TO_ROW_CAST(QualifiedObjectName.valueOf((CatalogSchemaName)BuiltInTypeAndFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)"$internal$json_string_to_row_cast"), false);

    private final QualifiedObjectName castName;
    private final boolean isOperatorType;

    private CastType(QualifiedObjectName castName, boolean isOperatorType) {
        this.castName = castName;
        this.isOperatorType = isOperatorType;
    }

    public QualifiedObjectName getCastName() {
        return this.castName;
    }

    public boolean isOperatorType() {
        return this.isOperatorType;
    }

    public static OperatorType toOperatorType(CastType castType) {
        switch (castType) {
            case CAST: {
                return OperatorType.CAST;
            }
            case SATURATED_FLOOR_CAST: {
                return OperatorType.SATURATED_FLOOR_CAST;
            }
        }
        throw new IllegalArgumentException(String.format("No OperatorType for CastType %s", new Object[]{castType}));
    }
}

