/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.common.type.Type;
import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.PolymorphicScalarFunctionBuilder;
import com.facebook.presto.metadata.SignatureBinder;
import com.facebook.presto.metadata.SqlScalarFunction;
import com.facebook.presto.operator.scalar.BuiltInScalarFunctionImplementation;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementationChoice;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.function.SqlFunctionVisibility;
import com.facebook.presto.util.Reflection;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Primitives;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

class PolymorphicScalarFunction
extends SqlScalarFunction {
    private final String description;
    private final SqlFunctionVisibility visibility;
    private final boolean deterministic;
    private final boolean calledOnNullInput;
    private final List<PolymorphicScalarFunctionChoice> choices;

    PolymorphicScalarFunction(Signature signature, String description, SqlFunctionVisibility visibility, boolean deterministic, boolean calledOnNullInput, List<PolymorphicScalarFunctionChoice> choices) {
        super(signature);
        this.description = description;
        this.visibility = visibility;
        this.deterministic = deterministic;
        this.calledOnNullInput = calledOnNullInput;
        this.choices = Objects.requireNonNull(choices, "choices is null");
    }

    public SqlFunctionVisibility getVisibility() {
        return this.visibility;
    }

    public boolean isDeterministic() {
        return this.deterministic;
    }

    @Override
    public boolean isCalledOnNullInput() {
        return this.calledOnNullInput;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public BuiltInScalarFunctionImplementation specialize(BoundVariables boundVariables, int arity, FunctionAndTypeManager functionAndTypeManager) {
        ImmutableList.Builder implementationChoices = ImmutableList.builder();
        for (PolymorphicScalarFunctionChoice choice : this.choices) {
            implementationChoices.add((Object)this.getScalarFunctionImplementationChoice(boundVariables, functionAndTypeManager, choice));
        }
        return new BuiltInScalarFunctionImplementation((List<ScalarFunctionImplementationChoice>)implementationChoices.build());
    }

    private ScalarFunctionImplementationChoice getScalarFunctionImplementationChoice(BoundVariables boundVariables, FunctionAndTypeManager functionAndTypeManager, PolymorphicScalarFunctionChoice choice) {
        List<Type> resolvedParameterTypes = SignatureBinder.applyBoundVariables(functionAndTypeManager, this.getSignature().getArgumentTypes(), boundVariables);
        Type resolvedReturnType = SignatureBinder.applyBoundVariables(functionAndTypeManager, this.getSignature().getReturnType(), boundVariables);
        PolymorphicScalarFunctionBuilder.SpecializeContext context = new PolymorphicScalarFunctionBuilder.SpecializeContext(boundVariables, resolvedParameterTypes, resolvedReturnType, functionAndTypeManager);
        Optional<Object> matchingMethod = Optional.empty();
        Optional<Object> matchingMethodsGroup = Optional.empty();
        for (PolymorphicScalarFunctionBuilder.MethodsGroup candidateMethodsGroup : choice.getMethodsGroups()) {
            for (PolymorphicScalarFunctionBuilder.MethodAndNativeContainerTypes candidateMethod : candidateMethodsGroup.getMethods()) {
                if (!PolymorphicScalarFunction.matchesParameterAndReturnTypes(candidateMethod, resolvedParameterTypes, resolvedReturnType, choice.getArgumentProperties(), choice.isNullableResult())) continue;
                if (matchingMethod.isPresent()) {
                    throw new IllegalStateException("two matching methods (" + ((PolymorphicScalarFunctionBuilder.MethodAndNativeContainerTypes)matchingMethod.get()).getMethod().getName() + " and " + candidateMethod.getMethod().getName() + ") for parameter types " + resolvedParameterTypes);
                }
                matchingMethod = Optional.of(candidateMethod);
                matchingMethodsGroup = Optional.of(candidateMethodsGroup);
            }
        }
        Preconditions.checkState((boolean)matchingMethod.isPresent(), (String)"no matching method for parameter types %s", resolvedParameterTypes);
        List<Object> extraParameters = PolymorphicScalarFunction.computeExtraParameters((PolymorphicScalarFunctionBuilder.MethodsGroup)matchingMethodsGroup.get(), context);
        MethodHandle methodHandle = this.applyExtraParameters(((PolymorphicScalarFunctionBuilder.MethodAndNativeContainerTypes)matchingMethod.get()).getMethod(), extraParameters, choice.getArgumentProperties());
        return new ScalarFunctionImplementationChoice(choice.isNullableResult(), choice.getArgumentProperties(), choice.getReturnPlaceConvention(), methodHandle, Optional.empty());
    }

    private static boolean matchesParameterAndReturnTypes(PolymorphicScalarFunctionBuilder.MethodAndNativeContainerTypes methodAndNativeContainerTypes, List<Type> resolvedTypes, Type returnType, List<ScalarFunctionImplementationChoice.ArgumentProperty> argumentProperties, boolean nullableResult) {
        Method method = methodAndNativeContainerTypes.getMethod();
        Preconditions.checkState((method.getParameterCount() >= resolvedTypes.size() ? 1 : 0) != 0, (String)"method %s has not enough arguments: %s (should have at least %s)", (Object)method.getName(), (Object)method.getParameterCount(), (Object)resolvedTypes.size());
        Class<?>[] methodParameterJavaTypes = method.getParameterTypes();
        int methodParameterIndex = 0;
        for (int i = 0; i < resolvedTypes.size(); ++i) {
            Class<?> actualType;
            ScalarFunctionImplementationChoice.NullConvention nullConvention = argumentProperties.get(i).getNullConvention();
            Class<?> expectedType = null;
            switch (nullConvention) {
                case RETURN_NULL_ON_NULL: 
                case USE_NULL_FLAG: {
                    expectedType = methodParameterJavaTypes[methodParameterIndex];
                    actualType = PolymorphicScalarFunction.getNullAwareContainerType(resolvedTypes.get(i).getJavaType(), false);
                    break;
                }
                case USE_BOXED_TYPE: {
                    expectedType = methodParameterJavaTypes[methodParameterIndex];
                    actualType = PolymorphicScalarFunction.getNullAwareContainerType(resolvedTypes.get(i).getJavaType(), true);
                    break;
                }
                case BLOCK_AND_POSITION: {
                    Optional<Class<?>> explicitNativeContainerTypes = methodAndNativeContainerTypes.getExplicitNativeContainerTypes().get(i);
                    if (explicitNativeContainerTypes.isPresent()) {
                        expectedType = explicitNativeContainerTypes.get();
                    }
                    actualType = PolymorphicScalarFunction.getNullAwareContainerType(resolvedTypes.get(i).getJavaType(), false);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("unknown NullConvention");
                }
            }
            if (!actualType.equals(expectedType)) {
                return false;
            }
            methodParameterIndex += nullConvention.getParameterCount();
        }
        return method.getReturnType().equals(PolymorphicScalarFunction.getNullAwareContainerType(returnType.getJavaType(), nullableResult));
    }

    private static List<Object> computeExtraParameters(PolymorphicScalarFunctionBuilder.MethodsGroup methodsGroup, PolymorphicScalarFunctionBuilder.SpecializeContext context) {
        return methodsGroup.getExtraParametersFunction().map(function -> (List)function.apply(context)).orElse(Collections.emptyList());
    }

    private static int getNullFlagsCount(List<ScalarFunctionImplementationChoice.ArgumentProperty> argumentProperties) {
        return (int)argumentProperties.stream().filter(argumentProperty -> argumentProperty.getNullConvention() == ScalarFunctionImplementationChoice.NullConvention.USE_NULL_FLAG).count();
    }

    private static int getBlockPositionCount(List<ScalarFunctionImplementationChoice.ArgumentProperty> argumentProperties) {
        return (int)argumentProperties.stream().filter(argumentProperty -> argumentProperty.getNullConvention() == ScalarFunctionImplementationChoice.NullConvention.BLOCK_AND_POSITION).count();
    }

    private MethodHandle applyExtraParameters(Method matchingMethod, List<Object> extraParameters, List<ScalarFunctionImplementationChoice.ArgumentProperty> argumentProperties) {
        Signature signature = this.getSignature();
        int expectedArgumentsCount = signature.getArgumentTypes().size() + PolymorphicScalarFunction.getNullFlagsCount(argumentProperties) + PolymorphicScalarFunction.getBlockPositionCount(argumentProperties) + extraParameters.size();
        int matchingMethodArgumentCount = matchingMethod.getParameterCount();
        Preconditions.checkState((matchingMethodArgumentCount == expectedArgumentsCount ? 1 : 0) != 0, (String)"method %s has invalid number of arguments: %s (should have %s)", (Object)matchingMethod.getName(), (Object)matchingMethodArgumentCount, (Object)expectedArgumentsCount);
        MethodHandle matchingMethodHandle = Reflection.methodHandle(matchingMethod);
        matchingMethodHandle = MethodHandles.insertArguments(matchingMethodHandle, matchingMethodArgumentCount - extraParameters.size(), extraParameters.toArray());
        return matchingMethodHandle;
    }

    private static Class<?> getNullAwareContainerType(Class<?> clazz, boolean nullable) {
        if (nullable) {
            return Primitives.wrap(clazz);
        }
        return clazz;
    }

    static final class PolymorphicScalarFunctionChoice {
        private final boolean nullableResult;
        private final List<ScalarFunctionImplementationChoice.ArgumentProperty> argumentProperties;
        private final ScalarFunctionImplementationChoice.ReturnPlaceConvention returnPlaceConvention;
        private final List<PolymorphicScalarFunctionBuilder.MethodsGroup> methodsGroups;

        PolymorphicScalarFunctionChoice(boolean nullableResult, List<ScalarFunctionImplementationChoice.ArgumentProperty> argumentProperties, ScalarFunctionImplementationChoice.ReturnPlaceConvention returnPlaceConvention, List<PolymorphicScalarFunctionBuilder.MethodsGroup> methodsGroups) {
            this.nullableResult = nullableResult;
            this.argumentProperties = ImmutableList.copyOf((Collection)Objects.requireNonNull(argumentProperties, "argumentProperties is null"));
            this.returnPlaceConvention = Objects.requireNonNull(returnPlaceConvention, "returnPlaceConvention is null");
            this.methodsGroups = ImmutableList.copyOf((Collection)Objects.requireNonNull(methodsGroups, "methodsWithExtraParametersFunctions is null"));
        }

        boolean isNullableResult() {
            return this.nullableResult;
        }

        List<PolymorphicScalarFunctionBuilder.MethodsGroup> getMethodsGroups() {
            return this.methodsGroups;
        }

        List<ScalarFunctionImplementationChoice.ArgumentProperty> getArgumentProperties() {
            return this.argumentProperties;
        }

        ScalarFunctionImplementationChoice.ReturnPlaceConvention getReturnPlaceConvention() {
            return this.returnPlaceConvention;
        }
    }
}

