/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.airlift.http.client.HttpClient;
import com.facebook.airlift.http.client.HttpUriBuilder;
import com.facebook.drift.client.DriftClient;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.memory.context.LocalMemoryContext;
import com.facebook.presto.operator.ExchangeClientStatus;
import com.facebook.presto.operator.HttpRpcShuffleClient;
import com.facebook.presto.operator.PageBufferClient;
import com.facebook.presto.operator.PageBufferClientStatus;
import com.facebook.presto.operator.RpcShuffleClient;
import com.facebook.presto.operator.ThriftRpcShuffleClient;
import com.facebook.presto.operator.WorkProcessor;
import com.facebook.presto.server.thrift.ThriftTaskClient;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.page.PageCodecMarker;
import com.facebook.presto.spi.page.SerializedPage;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.io.Closeable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class ExchangeClient
implements Closeable {
    private static final SerializedPage NO_MORE_PAGES = new SerializedPage(Slices.EMPTY_SLICE, PageCodecMarker.none(), 0, 0, 0L);
    private static final ListenableFuture<?> NOT_BLOCKED = Futures.immediateFuture(null);
    private final long bufferCapacity;
    private final DataSize maxResponseSize;
    private final int concurrentRequestMultiplier;
    private final Duration maxErrorDuration;
    private final boolean acknowledgePages;
    private final HttpClient httpClient;
    private final DriftClient<ThriftTaskClient> driftClient;
    private final ScheduledExecutorService scheduler;
    private boolean asyncPageTransportEnabled;
    @GuardedBy(value="this")
    private boolean noMoreLocations;
    private final ConcurrentMap<URI, PageBufferClient> allClients = new ConcurrentHashMap<URI, PageBufferClient>();
    private final ConcurrentMap<TaskId, URI> taskIdToLocationMap = new ConcurrentHashMap<TaskId, URI>();
    private final Set<TaskId> removedRemoteSourceTaskIds = ConcurrentHashMap.newKeySet();
    @GuardedBy(value="this")
    private final Deque<PageBufferClient> queuedClients = new LinkedList<PageBufferClient>();
    private final Set<PageBufferClient> completedClients = Sets.newConcurrentHashSet();
    private final Set<PageBufferClient> removedClients = Sets.newConcurrentHashSet();
    private final LinkedBlockingDeque<SerializedPage> pageBuffer = new LinkedBlockingDeque();
    @GuardedBy(value="this")
    private final List<SettableFuture<?>> blockedCallers = new ArrayList();
    @GuardedBy(value="this")
    private long bufferRetainedSizeInBytes;
    @GuardedBy(value="this")
    private long maxBufferRetainedSizeInBytes;
    @GuardedBy(value="this")
    private long successfulRequests;
    @GuardedBy(value="this")
    private final ExponentialMovingAverage responseSizeExponentialMovingAverage;
    private final AtomicBoolean closed = new AtomicBoolean();
    private final AtomicReference<Throwable> failure = new AtomicReference();
    private final LocalMemoryContext systemMemoryContext;
    private final Executor pageBufferClientCallbackExecutor;

    public ExchangeClient(DataSize bufferCapacity, DataSize maxResponseSize, int concurrentRequestMultiplier, Duration maxErrorDuration, boolean acknowledgePages, boolean asyncPageTransportEnabled, double responseSizeExponentialMovingAverageDecayingAlpha, HttpClient httpClient, DriftClient<ThriftTaskClient> driftClient, ScheduledExecutorService scheduler, LocalMemoryContext systemMemoryContext, Executor pageBufferClientCallbackExecutor) {
        Preconditions.checkArgument((responseSizeExponentialMovingAverageDecayingAlpha >= 0.0 && responseSizeExponentialMovingAverageDecayingAlpha <= 1.0 ? 1 : 0) != 0, (String)"responseSizeExponentialMovingAverageDecayingAlpha must be between 0 and 1: %s", (Object)responseSizeExponentialMovingAverageDecayingAlpha);
        this.bufferCapacity = bufferCapacity.toBytes();
        this.maxResponseSize = maxResponseSize;
        this.concurrentRequestMultiplier = concurrentRequestMultiplier;
        this.maxErrorDuration = maxErrorDuration;
        this.acknowledgePages = acknowledgePages;
        this.asyncPageTransportEnabled = asyncPageTransportEnabled;
        this.httpClient = httpClient;
        this.driftClient = driftClient;
        this.scheduler = scheduler;
        this.systemMemoryContext = systemMemoryContext;
        this.maxBufferRetainedSizeInBytes = Long.MIN_VALUE;
        this.pageBufferClientCallbackExecutor = Objects.requireNonNull(pageBufferClientCallbackExecutor, "pageBufferClientCallbackExecutor is null");
        this.responseSizeExponentialMovingAverage = new ExponentialMovingAverage(responseSizeExponentialMovingAverageDecayingAlpha, 0x100000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExchangeClientStatus getStatus() {
        ImmutableList.Builder pageBufferClientStatusBuilder = ImmutableList.builder();
        for (PageBufferClient client : this.allClients.values()) {
            pageBufferClientStatusBuilder.add((Object)client.getStatus());
        }
        ImmutableList pageBufferClientStatus = pageBufferClientStatusBuilder.build();
        ExchangeClient exchangeClient = this;
        synchronized (exchangeClient) {
            int bufferedPages = this.pageBuffer.size();
            if (bufferedPages > 0 && this.pageBuffer.peekLast() == NO_MORE_PAGES) {
                --bufferedPages;
            }
            return new ExchangeClientStatus(this.bufferRetainedSizeInBytes, this.maxBufferRetainedSizeInBytes, this.responseSizeExponentialMovingAverage.get(), this.successfulRequests, bufferedPages, this.noMoreLocations, (List<PageBufferClientStatus>)pageBufferClientStatus);
        }
    }

    public synchronized void addLocation(URI location, TaskId remoteSourceTaskId) {
        RpcShuffleClient resultClient;
        Objects.requireNonNull(location, "location is null");
        if (this.closed.get()) {
            return;
        }
        if (this.allClients.containsKey(location)) {
            return;
        }
        if (this.removedRemoteSourceTaskIds.contains(remoteSourceTaskId)) {
            return;
        }
        Preconditions.checkState((!this.noMoreLocations ? 1 : 0) != 0, (Object)"No more locations already set");
        Optional<URI> asyncPageTransportLocation = ExchangeClient.getAsyncPageTransportLocation(location, this.asyncPageTransportEnabled);
        switch (location.getScheme().toLowerCase(Locale.ENGLISH)) {
            case "http": 
            case "https": {
                resultClient = new HttpRpcShuffleClient(this.httpClient, location, asyncPageTransportLocation);
                break;
            }
            case "thrift": {
                resultClient = new ThriftRpcShuffleClient(this.driftClient, location);
                break;
            }
            default: {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "unsupported task result client scheme " + location.getScheme());
            }
        }
        PageBufferClient client = new PageBufferClient(resultClient, this.maxErrorDuration, this.acknowledgePages, location, asyncPageTransportLocation, new ExchangeClientCallback(), this.scheduler, this.pageBufferClientCallbackExecutor);
        this.allClients.put(location, client);
        Preconditions.checkState((this.taskIdToLocationMap.put(remoteSourceTaskId, location) == null ? 1 : 0) != 0, (Object)("Duplicate remoteSourceTaskId: " + remoteSourceTaskId));
        this.queuedClients.add(client);
        this.scheduleRequestIfNecessary();
    }

    public synchronized void removeRemoteSource(TaskId sourceTaskId) {
        Objects.requireNonNull(sourceTaskId, "sourceTaskId is null");
        if (this.closed.get()) {
            return;
        }
        this.removedRemoteSourceTaskIds.add(sourceTaskId);
        URI location = (URI)this.taskIdToLocationMap.get(sourceTaskId);
        if (location == null) {
            return;
        }
        PageBufferClient client = (PageBufferClient)this.allClients.get(location);
        if (client == null) {
            return;
        }
        ExchangeClient.closeQuietly(client);
        this.removedClients.add(client);
        this.completedClients.add(client);
    }

    public synchronized void noMoreLocations() {
        this.noMoreLocations = true;
        this.scheduleRequestIfNecessary();
    }

    public WorkProcessor<SerializedPage> pages() {
        return WorkProcessor.create(() -> {
            SerializedPage page = this.pollPage();
            if (page == null) {
                if (this.isFinished()) {
                    return WorkProcessor.ProcessState.finished();
                }
                ListenableFuture<?> blocked = this.isBlocked();
                if (!blocked.isDone()) {
                    return WorkProcessor.ProcessState.blocked(blocked);
                }
                return WorkProcessor.ProcessState.yield();
            }
            return WorkProcessor.ProcessState.ofResult(page);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public SerializedPage pollPage() {
        Preconditions.checkState((!Thread.holdsLock(this) ? 1 : 0) != 0, (Object)"Can not get next page while holding a lock on this");
        this.throwIfFailed();
        if (this.closed.get()) {
            return null;
        }
        SerializedPage page = this.pageBuffer.poll();
        if (page == null) {
            return null;
        }
        if (page == NO_MORE_PAGES) {
            this.close();
            this.notifyBlockedCallers();
            return null;
        }
        ExchangeClient exchangeClient = this;
        synchronized (exchangeClient) {
            if (!this.closed.get()) {
                this.bufferRetainedSizeInBytes -= page.getRetainedSizeInBytes();
                this.systemMemoryContext.setBytes(this.bufferRetainedSizeInBytes);
            }
            this.scheduleRequestIfNecessary();
        }
        return page;
    }

    public boolean isFinished() {
        this.throwIfFailed();
        return this.isClosed() && this.completedClients.size() == this.allClients.size();
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    @Override
    public synchronized void close() {
        if (!this.closed.compareAndSet(false, true)) {
            return;
        }
        for (PageBufferClient client : this.allClients.values()) {
            ExchangeClient.closeQuietly(client);
        }
        this.pageBuffer.clear();
        this.systemMemoryContext.setBytes(0L);
        this.bufferRetainedSizeInBytes = 0L;
        if (this.pageBuffer.peekLast() != NO_MORE_PAGES) {
            Preconditions.checkState((boolean)this.pageBuffer.add(NO_MORE_PAGES), (Object)"Could not add no more pages marker");
        }
        this.notifyBlockedCallers();
    }

    public synchronized void scheduleRequestIfNecessary() {
        if (this.isFinished() || this.isFailed()) {
            return;
        }
        if (this.noMoreLocations && this.completedClients.size() == this.allClients.size()) {
            if (this.pageBuffer.peekLast() != NO_MORE_PAGES) {
                Preconditions.checkState((boolean)this.pageBuffer.add(NO_MORE_PAGES), (Object)"Could not add no more pages marker");
            }
            if (this.pageBuffer.peek() == NO_MORE_PAGES) {
                this.close();
            }
            this.notifyBlockedCallers();
            return;
        }
        long neededBytes = this.bufferCapacity - this.bufferRetainedSizeInBytes;
        if (neededBytes <= 0L) {
            return;
        }
        long averageResponseSize = Math.max(1L, this.responseSizeExponentialMovingAverage.get());
        int clientCount = (int)(1.0 * (double)neededBytes / (double)averageResponseSize * (double)this.concurrentRequestMultiplier);
        clientCount = Math.max(clientCount, 1);
        int pendingClients = this.allClients.size() - this.queuedClients.size() - this.completedClients.size();
        clientCount -= pendingClients;
        int i = 0;
        while (i < clientCount) {
            PageBufferClient client = this.queuedClients.poll();
            if (client == null) {
                return;
            }
            if (this.removedClients.contains(client)) continue;
            DataSize max = new DataSize((double)Math.min(averageResponseSize * 2L, this.maxResponseSize.toBytes()), DataSize.Unit.BYTE);
            client.scheduleRequest(max);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<?> isBlocked() {
        if (this.isClosed() || this.isFailed() || this.pageBuffer.peek() != null) {
            return NOT_BLOCKED;
        }
        ExchangeClient exchangeClient = this;
        synchronized (exchangeClient) {
            if (this.isClosed() || this.isFailed() || this.pageBuffer.peek() != null) {
                return NOT_BLOCKED;
            }
            SettableFuture future = SettableFuture.create();
            this.blockedCallers.add(future);
            return future;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addPages(List<SerializedPage> pages) {
        long pagesRetainedSizeInBytes = 0L;
        long responseSize = 0L;
        for (SerializedPage page : pages) {
            pagesRetainedSizeInBytes += page.getRetainedSizeInBytes();
            responseSize += (long)page.getSizeInBytes();
        }
        ImmutableList notify = ImmutableList.of();
        ExchangeClient exchangeClient = this;
        synchronized (exchangeClient) {
            if (this.isClosed() || this.isFailed()) {
                return false;
            }
            if (!pages.isEmpty()) {
                this.pageBuffer.addAll(pages);
                this.bufferRetainedSizeInBytes += pagesRetainedSizeInBytes;
                this.maxBufferRetainedSizeInBytes = Math.max(this.maxBufferRetainedSizeInBytes, this.bufferRetainedSizeInBytes);
                this.systemMemoryContext.setBytes(this.bufferRetainedSizeInBytes);
                notify = ImmutableList.copyOf(this.blockedCallers);
                this.blockedCallers.clear();
            }
            ++this.successfulRequests;
            this.responseSizeExponentialMovingAverage.update(responseSize);
        }
        this.notifyListeners((List<SettableFuture<?>>)notify);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyBlockedCallers() {
        ImmutableList callers;
        ExchangeClient exchangeClient = this;
        synchronized (exchangeClient) {
            callers = ImmutableList.copyOf(this.blockedCallers);
            this.blockedCallers.clear();
        }
        this.notifyListeners((List<SettableFuture<?>>)callers);
    }

    private void notifyListeners(List<SettableFuture<?>> blockedCallers) {
        for (SettableFuture<?> blockedCaller : blockedCallers) {
            this.scheduler.execute(() -> blockedCaller.set(null));
        }
    }

    private synchronized void requestComplete(PageBufferClient client) {
        if (!this.queuedClients.contains(client)) {
            this.queuedClients.add(client);
        }
        this.scheduleRequestIfNecessary();
    }

    private synchronized void clientFinished(PageBufferClient client) {
        Objects.requireNonNull(client, "client is null");
        this.completedClients.add(client);
        this.scheduleRequestIfNecessary();
    }

    private synchronized void clientFailed(PageBufferClient client, Throwable cause) {
        if (this.removedClients.contains(client)) {
            return;
        }
        if (!this.isClosed()) {
            this.failure.compareAndSet(null, cause);
            this.notifyBlockedCallers();
        }
    }

    private boolean isFailed() {
        return this.failure.get() != null;
    }

    private void throwIfFailed() {
        Throwable t = this.failure.get();
        if (t != null) {
            Throwables.throwIfUnchecked((Throwable)t);
            throw new RuntimeException(t);
        }
    }

    private static void closeQuietly(PageBufferClient client) {
        try {
            client.close();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    private static Optional<URI> getAsyncPageTransportLocation(URI location, boolean asyncPageTransportEnabled) {
        if (asyncPageTransportEnabled) {
            String path = location.getPath().replace("v1/task", "v1/task/async");
            return Optional.of(HttpUriBuilder.uriBuilderFrom((URI)location).replacePath(path).build());
        }
        return Optional.empty();
    }

    private static class ExponentialMovingAverage {
        private final double alpha;
        private double oldValue;

        public ExponentialMovingAverage(double alpha, long initialValue) {
            this.alpha = alpha;
            this.oldValue = initialValue;
        }

        public void update(long value) {
            double newValue;
            this.oldValue = newValue = this.oldValue + this.alpha * ((double)value - this.oldValue);
        }

        public long get() {
            return (long)this.oldValue;
        }
    }

    private class ExchangeClientCallback
    implements PageBufferClient.ClientCallback {
        private ExchangeClientCallback() {
        }

        @Override
        public boolean addPages(PageBufferClient client, List<SerializedPage> pages) {
            Objects.requireNonNull(client, "client is null");
            Objects.requireNonNull(pages, "pages is null");
            return ExchangeClient.this.addPages(pages);
        }

        @Override
        public void requestComplete(PageBufferClient client) {
            Objects.requireNonNull(client, "client is null");
            ExchangeClient.this.requestComplete(client);
        }

        @Override
        public void clientFinished(PageBufferClient client) {
            ExchangeClient.this.clientFinished(client);
        }

        @Override
        public void clientFailed(PageBufferClient client, Throwable cause) {
            Objects.requireNonNull(client, "client is null");
            Objects.requireNonNull(cause, "cause is null");
            ExchangeClient.this.clientFailed(client, cause);
        }
    }
}

