/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.operator.LookupSource;
import com.google.common.primitives.Ints;
import java.util.List;
import java.util.OptionalInt;
import javax.annotation.Nullable;

public class JoinProbe {
    private final int[] probeOutputChannels;
    private final int positionCount;
    private final Page page;
    private final Page probePage;
    @Nullable
    private final Block probeHashBlock;
    private final boolean probeMayHaveNull;
    private int position = -1;

    private JoinProbe(int[] probeOutputChannels, Page page, Page probePage, @Nullable Block probeHashBlock) {
        this.probeOutputChannels = probeOutputChannels;
        this.positionCount = page.getPositionCount();
        this.page = page;
        this.probePage = probePage;
        this.probeHashBlock = probeHashBlock;
        this.probeMayHaveNull = JoinProbe.probeMayHaveNull(probePage);
    }

    public int[] getOutputChannels() {
        return this.probeOutputChannels;
    }

    public boolean advanceNextPosition() {
        return ++this.position < this.positionCount;
    }

    public long getCurrentJoinPosition(LookupSource lookupSource) {
        if (this.probeMayHaveNull && this.currentRowContainsNull()) {
            return -1L;
        }
        if (this.probeHashBlock != null) {
            long rawHash = BigintType.BIGINT.getLong(this.probeHashBlock, this.position);
            return lookupSource.getJoinPosition(this.position, this.probePage, this.page, rawHash);
        }
        return lookupSource.getJoinPosition(this.position, this.probePage, this.page);
    }

    public int getPosition() {
        return this.position;
    }

    public Page getPage() {
        return this.page;
    }

    private boolean currentRowContainsNull() {
        for (int i = 0; i < this.probePage.getChannelCount(); ++i) {
            if (!this.probePage.getBlock(i).isNull(this.position)) continue;
            return true;
        }
        return false;
    }

    private static boolean probeMayHaveNull(Page probePage) {
        for (int i = 0; i < probePage.getChannelCount(); ++i) {
            if (!probePage.getBlock(i).mayHaveNull()) continue;
            return true;
        }
        return false;
    }

    public static class JoinProbeFactory {
        private final int[] probeOutputChannels;
        private final int[] probeJoinChannels;
        private final int probeHashChannel;

        public JoinProbeFactory(int[] probeOutputChannels, List<Integer> probeJoinChannels, OptionalInt probeHashChannel) {
            this.probeOutputChannels = probeOutputChannels;
            this.probeJoinChannels = Ints.toArray(probeJoinChannels);
            this.probeHashChannel = probeHashChannel.orElse(-1);
        }

        public JoinProbe createJoinProbe(Page page) {
            Page probePage = page.getLoadedPage(this.probeJoinChannels);
            return new JoinProbe(this.probeOutputChannels, page, probePage, this.probeHashChannel >= 0 ? page.getBlock(this.probeHashChannel).getLoadedBlock() : null);
        }
    }
}

