/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.drift.annotations.ThriftConstructor;
import com.facebook.drift.annotations.ThriftField;
import com.facebook.drift.annotations.ThriftStruct;
import com.facebook.presto.operator.OperatorInfo;
import com.facebook.presto.util.Mergeable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import io.airlift.units.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

@ThriftStruct
public class TableWriterMergeInfo
implements Mergeable<TableWriterMergeInfo>,
OperatorInfo {
    private final Duration statisticsWallTime;
    private final Duration statisticsCpuTime;

    @JsonCreator
    @ThriftConstructor
    public TableWriterMergeInfo(@JsonProperty(value="statisticsWallTime") Duration statisticsWallTime, @JsonProperty(value="statisticsCpuTime") Duration statisticsCpuTime) {
        this.statisticsWallTime = Objects.requireNonNull(statisticsWallTime, "statisticsWallTime is null");
        this.statisticsCpuTime = Objects.requireNonNull(statisticsCpuTime, "statisticsCpuTime is null");
    }

    @JsonProperty
    @ThriftField(value=1)
    public Duration getStatisticsWallTime() {
        return this.statisticsWallTime;
    }

    @JsonProperty
    @ThriftField(value=2)
    public Duration getStatisticsCpuTime() {
        return this.statisticsCpuTime;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("statisticsWallTime", (Object)this.statisticsWallTime).add("statisticsCpuTime", (Object)this.statisticsCpuTime).toString();
    }

    @Override
    public TableWriterMergeInfo mergeWith(TableWriterMergeInfo other) {
        return new TableWriterMergeInfo(new Duration((double)(this.statisticsWallTime.toMillis() + other.statisticsWallTime.toMillis()), TimeUnit.MILLISECONDS), new Duration((double)(this.statisticsCpuTime.toMillis() + other.statisticsCpuTime.toMillis()), TimeUnit.MILLISECONDS));
    }

    @Override
    public boolean isFinal() {
        return true;
    }
}

