/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.drift.annotations.ThriftConstructor;
import com.facebook.drift.annotations.ThriftField;
import com.facebook.drift.annotations.ThriftStruct;
import com.facebook.presto.operator.OperatorInfo;
import com.facebook.presto.operator.PagesIndex;
import com.facebook.presto.operator.window.WindowPartition;
import com.facebook.presto.util.Mergeable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@ThriftStruct
public class WindowInfo
implements Mergeable<WindowInfo>,
OperatorInfo {
    private static final WindowInfo EMPTY_INFO = new WindowInfo((List<DriverWindowInfo>)ImmutableList.of());
    private final List<DriverWindowInfo> windowInfos;

    public static WindowInfo emptyInfo() {
        return EMPTY_INFO;
    }

    @JsonCreator
    @ThriftConstructor
    public WindowInfo(@JsonProperty(value="windowInfos") List<DriverWindowInfo> windowInfos) {
        this.windowInfos = ImmutableList.copyOf(windowInfos);
    }

    @JsonProperty
    @ThriftField(value=1)
    public List<DriverWindowInfo> getWindowInfos() {
        return this.windowInfos;
    }

    @Override
    public WindowInfo mergeWith(WindowInfo other) {
        int otherSize = other.windowInfos.size();
        if (otherSize == 0) {
            return this;
        }
        int thisSize = this.windowInfos.size();
        if (thisSize == 0) {
            return other;
        }
        return new WindowInfo((List<DriverWindowInfo>)ImmutableList.builderWithExpectedSize((int)(thisSize + otherSize)).addAll(this.windowInfos).addAll(other.windowInfos).build());
    }

    @Immutable
    public static class IndexInfo {
        private final long totalRowsCount;
        private final long sizeInBytes;
        private final double sumSquaredDifferencesSizeInPartition;
        private final long numberOfPartitions;

        public IndexInfo(long totalRowsCount, long sizeInBytes, double sumSquaredDifferencesSizeInPartition, long numberOfPartitions) {
            this.totalRowsCount = totalRowsCount;
            this.sizeInBytes = sizeInBytes;
            this.sumSquaredDifferencesSizeInPartition = sumSquaredDifferencesSizeInPartition;
            this.numberOfPartitions = numberOfPartitions;
        }

        public long getTotalRowsCount() {
            return this.totalRowsCount;
        }

        public long getSizeInBytes() {
            return this.sizeInBytes;
        }

        public double getSumSquaredDifferencesSizeInPartition() {
            return this.sumSquaredDifferencesSizeInPartition;
        }

        public long getNumberOfPartitions() {
            return this.numberOfPartitions;
        }
    }

    private static class IndexInfoBuilder {
        private final long rowsNumber;
        private final long sizeInBytes;
        private final ImmutableList.Builder<Integer> partitionsSizes = ImmutableList.builder();

        public IndexInfoBuilder(long rowsNumber, long sizeInBytes) {
            this.rowsNumber = rowsNumber;
            this.sizeInBytes = sizeInBytes;
        }

        public void addPartition(WindowPartition partition) {
            this.partitionsSizes.add((Object)(partition.getPartitionEnd() - partition.getPartitionStart()));
        }

        public Optional<IndexInfo> build() {
            ImmutableList partitions = this.partitionsSizes.build();
            if (partitions.isEmpty()) {
                return Optional.empty();
            }
            double avgSize = partitions.stream().mapToLong(Integer::longValue).average().getAsDouble();
            double squaredDifferences = partitions.stream().mapToDouble(size -> Math.pow((double)size.intValue() - avgSize, 2.0)).sum();
            Preconditions.checkState((partitions.stream().mapToLong(Integer::longValue).sum() == this.rowsNumber ? 1 : 0) != 0, (Object)"Total number of rows in index does not match number of rows in partitions within that index");
            return Optional.of(new IndexInfo(this.rowsNumber, this.sizeInBytes, squaredDifferences, partitions.size()));
        }
    }

    @ThriftStruct
    @Immutable
    public static class DriverWindowInfo {
        private final double sumSquaredDifferencesPositionsOfIndex;
        private final double sumSquaredDifferencesSizeOfIndex;
        private final double sumSquaredDifferencesSizeInPartition;
        private final long totalPartitionsCount;
        private final long totalRowsCount;
        private final long numberOfIndexes;

        @JsonCreator
        @ThriftConstructor
        public DriverWindowInfo(@JsonProperty(value="sumSquaredDifferencesPositionsOfIndex") double sumSquaredDifferencesPositionsOfIndex, @JsonProperty(value="sumSquaredDifferencesSizeOfIndex") double sumSquaredDifferencesSizeOfIndex, @JsonProperty(value="sumSquaredDifferencesSizeInPartition") double sumSquaredDifferencesSizeInPartition, @JsonProperty(value="totalPartitionsCount") long totalPartitionsCount, @JsonProperty(value="totalRowsCount") long totalRowsCount, @JsonProperty(value="numberOfIndexes") long numberOfIndexes) {
            this.sumSquaredDifferencesPositionsOfIndex = sumSquaredDifferencesPositionsOfIndex;
            this.sumSquaredDifferencesSizeOfIndex = sumSquaredDifferencesSizeOfIndex;
            this.sumSquaredDifferencesSizeInPartition = sumSquaredDifferencesSizeInPartition;
            this.totalPartitionsCount = totalPartitionsCount;
            this.totalRowsCount = totalRowsCount;
            this.numberOfIndexes = numberOfIndexes;
        }

        @JsonProperty
        @ThriftField(value=1)
        public double getSumSquaredDifferencesPositionsOfIndex() {
            return this.sumSquaredDifferencesPositionsOfIndex;
        }

        @JsonProperty
        @ThriftField(value=2)
        public double getSumSquaredDifferencesSizeOfIndex() {
            return this.sumSquaredDifferencesSizeOfIndex;
        }

        @JsonProperty
        @ThriftField(value=3)
        public double getSumSquaredDifferencesSizeInPartition() {
            return this.sumSquaredDifferencesSizeInPartition;
        }

        @JsonProperty
        @ThriftField(value=4)
        public long getTotalPartitionsCount() {
            return this.totalPartitionsCount;
        }

        @JsonProperty
        @ThriftField(value=5)
        public long getTotalRowsCount() {
            return this.totalRowsCount;
        }

        @JsonProperty
        @ThriftField(value=6)
        public long getNumberOfIndexes() {
            return this.numberOfIndexes;
        }
    }

    static class DriverWindowInfoBuilder {
        private final ImmutableList.Builder<IndexInfo> indexInfosBuilder = ImmutableList.builder();
        private IndexInfoBuilder currentIndexInfoBuilder;

        DriverWindowInfoBuilder() {
        }

        public void addIndex(PagesIndex index) {
            if (this.currentIndexInfoBuilder != null) {
                Optional<IndexInfo> indexInfo = this.currentIndexInfoBuilder.build();
                indexInfo.ifPresent(arg_0 -> this.indexInfosBuilder.add(arg_0));
            }
            this.currentIndexInfoBuilder = new IndexInfoBuilder(index.getPositionCount(), index.getEstimatedSize().toBytes());
        }

        public void addPartition(WindowPartition partition) {
            Preconditions.checkState((this.currentIndexInfoBuilder != null ? 1 : 0) != 0, (Object)"addIndex must be called before addPartition");
            this.currentIndexInfoBuilder.addPartition(partition);
        }

        public DriverWindowInfo build() {
            ImmutableList indexInfos;
            if (this.currentIndexInfoBuilder != null) {
                Optional<IndexInfo> indexInfo = this.currentIndexInfoBuilder.build();
                indexInfo.ifPresent(arg_0 -> this.indexInfosBuilder.add(arg_0));
                this.currentIndexInfoBuilder = null;
            }
            if ((indexInfos = this.indexInfosBuilder.build()).isEmpty()) {
                return new DriverWindowInfo(0.0, 0.0, 0.0, 0L, 0L, 0L);
            }
            long totalRowsCount = indexInfos.stream().mapToLong(IndexInfo::getTotalRowsCount).sum();
            double averageIndexPositions = totalRowsCount / (long)indexInfos.size();
            double squaredDifferencesPositionsOfIndex = indexInfos.stream().mapToDouble(index -> Math.pow((double)index.getTotalRowsCount() - averageIndexPositions, 2.0)).sum();
            double averageIndexSize = indexInfos.stream().mapToLong(IndexInfo::getSizeInBytes).average().getAsDouble();
            double squaredDifferencesSizeOfIndex = indexInfos.stream().mapToDouble(index -> Math.pow((double)index.getSizeInBytes() - averageIndexSize, 2.0)).sum();
            double squaredDifferencesSizeInPartition = indexInfos.stream().mapToDouble(IndexInfo::getSumSquaredDifferencesSizeInPartition).sum();
            long totalPartitionsCount = indexInfos.stream().mapToLong(IndexInfo::getNumberOfPartitions).sum();
            return new DriverWindowInfo(squaredDifferencesPositionsOfIndex, squaredDifferencesSizeOfIndex, squaredDifferencesSizeInPartition, totalPartitionsCount, totalRowsCount, indexInfos.size());
        }
    }
}

