/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.bytecode.DynamicClassLoader;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.Decimals;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.UnscaledDecimal128Arithmetic;
import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.SignatureBinder;
import com.facebook.presto.metadata.SqlAggregationFunction;
import com.facebook.presto.operator.aggregation.AccumulatorCompiler;
import com.facebook.presto.operator.aggregation.AggregationMetadata;
import com.facebook.presto.operator.aggregation.AggregationUtils;
import com.facebook.presto.operator.aggregation.GenericAccumulatorFactoryBinder;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.operator.aggregation.state.LongDecimalWithOverflowAndLongState;
import com.facebook.presto.operator.aggregation.state.LongDecimalWithOverflowAndLongStateFactory;
import com.facebook.presto.operator.aggregation.state.LongDecimalWithOverflowAndLongStateSerializer;
import com.facebook.presto.spi.function.LongVariableConstraint;
import com.facebook.presto.spi.function.TypeVariableConstraint;
import com.facebook.presto.util.Reflection;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import io.airlift.slice.Slice;
import java.lang.invoke.MethodHandle;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.Set;

public class DecimalAverageAggregation
extends SqlAggregationFunction {
    private static final DecimalType LONG_DECIMAL_TYPE = DecimalType.createDecimalType((int)38, (int)0);
    private static final DecimalType SHORT_DECIMAL_TYPE = DecimalType.createDecimalType((int)18, (int)0);
    public static final DecimalAverageAggregation DECIMAL_AVERAGE_AGGREGATION = new DecimalAverageAggregation();
    private static final String NAME = "avg";
    private static final MethodHandle SHORT_DECIMAL_INPUT_FUNCTION = Reflection.methodHandle(DecimalAverageAggregation.class, "inputShortDecimal", LongDecimalWithOverflowAndLongState.class, Block.class, Integer.TYPE);
    private static final MethodHandle LONG_DECIMAL_INPUT_FUNCTION = Reflection.methodHandle(DecimalAverageAggregation.class, "inputLongDecimal", LongDecimalWithOverflowAndLongState.class, Block.class, Integer.TYPE);
    private static final MethodHandle SHORT_DECIMAL_OUTPUT_FUNCTION = Reflection.methodHandle(DecimalAverageAggregation.class, "outputShortDecimal", DecimalType.class, LongDecimalWithOverflowAndLongState.class, BlockBuilder.class);
    private static final MethodHandle LONG_DECIMAL_OUTPUT_FUNCTION = Reflection.methodHandle(DecimalAverageAggregation.class, "outputLongDecimal", DecimalType.class, LongDecimalWithOverflowAndLongState.class, BlockBuilder.class);
    private static final MethodHandle COMBINE_FUNCTION = Reflection.methodHandle(DecimalAverageAggregation.class, "combine", LongDecimalWithOverflowAndLongState.class, LongDecimalWithOverflowAndLongState.class);
    private static final BigInteger OVERFLOW_MULTIPLIER = new BigInteger("2").shiftLeft(126);

    public DecimalAverageAggregation() {
        super(NAME, (List<TypeVariableConstraint>)ImmutableList.of(), (List<LongVariableConstraint>)ImmutableList.of(), TypeSignature.parseTypeSignature((String)"decimal(p,s)", (Set)ImmutableSet.of((Object)"p", (Object)"s")), (List<TypeSignature>)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"decimal(p,s)", (Set)ImmutableSet.of((Object)"p", (Object)"s"))));
    }

    public String getDescription() {
        return "Calculates the average value";
    }

    @Override
    public InternalAggregationFunction specialize(BoundVariables boundVariables, int arity, FunctionAndTypeManager functionAndTypeManager) {
        Type type = (Type)Iterables.getOnlyElement(SignatureBinder.applyBoundVariables(functionAndTypeManager, this.getSignature().getArgumentTypes(), boundVariables));
        return DecimalAverageAggregation.generateAggregation(type);
    }

    private static InternalAggregationFunction generateAggregation(Type type) {
        MethodHandle outputFunction;
        MethodHandle inputFunction;
        Preconditions.checkArgument((boolean)(type instanceof DecimalType), (Object)"type must be Decimal");
        DynamicClassLoader classLoader = new DynamicClassLoader(DecimalAverageAggregation.class.getClassLoader());
        ImmutableList inputTypes = ImmutableList.of((Object)type);
        Class<LongDecimalWithOverflowAndLongState> stateInterface = LongDecimalWithOverflowAndLongState.class;
        LongDecimalWithOverflowAndLongStateSerializer stateSerializer = new LongDecimalWithOverflowAndLongStateSerializer();
        if (((DecimalType)type).isShort()) {
            inputFunction = SHORT_DECIMAL_INPUT_FUNCTION;
            outputFunction = SHORT_DECIMAL_OUTPUT_FUNCTION;
        } else {
            inputFunction = LONG_DECIMAL_INPUT_FUNCTION;
            outputFunction = LONG_DECIMAL_OUTPUT_FUNCTION;
        }
        outputFunction = outputFunction.bindTo(type);
        AggregationMetadata metadata = new AggregationMetadata(AggregationUtils.generateAggregationName(NAME, type.getTypeSignature(), (List)inputTypes.stream().map(Type::getTypeSignature).collect(ImmutableList.toImmutableList())), DecimalAverageAggregation.createInputParameterMetadata(type), inputFunction, COMBINE_FUNCTION, outputFunction, (List<AggregationMetadata.AccumulatorStateDescriptor>)ImmutableList.of((Object)new AggregationMetadata.AccumulatorStateDescriptor(stateInterface, stateSerializer, new LongDecimalWithOverflowAndLongStateFactory())), type);
        Type intermediateType = stateSerializer.getSerializedType();
        GenericAccumulatorFactoryBinder factory = AccumulatorCompiler.generateAccumulatorFactoryBinder(metadata, classLoader);
        return new InternalAggregationFunction(NAME, (List<Type>)inputTypes, (List<Type>)ImmutableList.of((Object)intermediateType), type, true, false, factory);
    }

    private static List<AggregationMetadata.ParameterMetadata> createInputParameterMetadata(Type type) {
        return ImmutableList.of((Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.STATE), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.BLOCK_INPUT_CHANNEL, type), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.BLOCK_INDEX));
    }

    public static void inputShortDecimal(LongDecimalWithOverflowAndLongState state, Block block, int position) {
        state.incrementLong();
        Slice currentSum = state.getLongDecimal();
        if (currentSum == null) {
            currentSum = UnscaledDecimal128Arithmetic.unscaledDecimal();
            state.setLongDecimal(currentSum);
        }
        state.addOverflow(UnscaledDecimal128Arithmetic.addWithOverflow((Slice)currentSum, (Slice)UnscaledDecimal128Arithmetic.unscaledDecimal((long)SHORT_DECIMAL_TYPE.getLong(block, position)), (Slice)currentSum));
    }

    public static void inputLongDecimal(LongDecimalWithOverflowAndLongState state, Block block, int position) {
        state.incrementLong();
        Slice currentSum = state.getLongDecimal();
        if (currentSum == null) {
            currentSum = UnscaledDecimal128Arithmetic.unscaledDecimal();
            state.setLongDecimal(currentSum);
        }
        state.addOverflow(UnscaledDecimal128Arithmetic.addWithOverflow((Slice)currentSum, (Slice)LONG_DECIMAL_TYPE.getSlice(block, position), (Slice)currentSum));
    }

    public static void combine(LongDecimalWithOverflowAndLongState state, LongDecimalWithOverflowAndLongState otherState) {
        state.addLong(otherState.getLong());
        long overflowToAdd = otherState.getOverflow();
        Slice currentState = state.getLongDecimal();
        Slice otherDecimal = otherState.getLongDecimal();
        if (currentState == null) {
            state.setLongDecimal(otherDecimal);
        } else {
            overflowToAdd += UnscaledDecimal128Arithmetic.addWithOverflow((Slice)currentState, (Slice)otherDecimal, (Slice)currentState);
        }
        state.addOverflow(overflowToAdd);
    }

    public static void outputShortDecimal(DecimalType type, LongDecimalWithOverflowAndLongState state, BlockBuilder out) {
        long count = state.getLong();
        if (count == 0L) {
            out.appendNull();
        } else {
            Decimals.writeShortDecimal((BlockBuilder)out, (long)DecimalAverageAggregation.average(count, state.getOverflow(), state.getLongDecimal(), type.getScale()).unscaledValue().longValueExact());
        }
    }

    public static void outputLongDecimal(DecimalType type, LongDecimalWithOverflowAndLongState state, BlockBuilder out) {
        long count = state.getLong();
        if (count == 0L) {
            out.appendNull();
        } else {
            Decimals.writeBigDecimal((DecimalType)type, (BlockBuilder)out, (BigDecimal)DecimalAverageAggregation.average(count, state.getOverflow(), state.getLongDecimal(), type.getScale()));
        }
    }

    @VisibleForTesting
    public static BigDecimal average(LongDecimalWithOverflowAndLongState state, DecimalType type) {
        return DecimalAverageAggregation.average(state.getLong(), state.getOverflow(), state.getLongDecimal(), type.getScale());
    }

    private static BigDecimal average(long count, long overflow, Slice unscaledDecimal, int scale) {
        BigDecimal sum = new BigDecimal(Decimals.decodeUnscaledValue((Slice)unscaledDecimal), scale);
        if (overflow != 0L) {
            sum = sum.add(new BigDecimal(OVERFLOW_MULTIPLIER.multiply(BigInteger.valueOf(overflow))));
        }
        return sum.divide(BigDecimal.valueOf(count), scale, 4);
    }
}

