/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.operator.aggregation.state.LongAndDoubleState;
import com.facebook.presto.spi.function.AggregationFunction;
import com.facebook.presto.spi.function.CombineFunction;
import com.facebook.presto.spi.function.InputFunction;
import com.facebook.presto.spi.function.OutputFunction;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.type.IntervalYearMonthType;

@AggregationFunction(value="avg")
public final class IntervalYearToMonthAverageAggregation {
    private IntervalYearToMonthAverageAggregation() {
    }

    @InputFunction
    public static void input(LongAndDoubleState state, @SqlType(value="interval year to month") long value) {
        state.setLong(state.getLong() + 1L);
        state.setDouble(state.getDouble() + (double)value);
    }

    @CombineFunction
    public static void combine(LongAndDoubleState state, LongAndDoubleState otherState) {
        state.setLong(state.getLong() + otherState.getLong());
        state.setDouble(state.getDouble() + otherState.getDouble());
    }

    @OutputFunction(value="interval year to month")
    public static void output(LongAndDoubleState state, BlockBuilder out) {
        long count = state.getLong();
        if (count == 0L) {
            out.appendNull();
        } else {
            double value = state.getDouble();
            IntervalYearMonthType.INTERVAL_YEAR_MONTH.writeLong(out, Math.round(value / (double)count));
        }
    }
}

