/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.differentialentropy;

import com.facebook.presto.operator.aggregation.differentialentropy.DifferentialEntropyStateStrategy;
import com.facebook.presto.operator.aggregation.differentialentropy.EntropyCalculations;
import com.facebook.presto.operator.aggregation.reservoirsample.WeightedDoubleReservoirSample;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.google.common.base.Verify;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;

public class WeightedReservoirSampleStateStrategy
implements DifferentialEntropyStateStrategy {
    private final WeightedDoubleReservoirSample reservoir;

    public WeightedReservoirSampleStateStrategy(long maxSamples) {
        if (maxSamples <= 0L) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("In differential_entropy UDF, max samples must be positive: %s", maxSamples));
        }
        if (maxSamples >= 1000000L) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("In differential_entropy UDF, max samples  must be capped: max_samples=%s, cap=%s", maxSamples, 1000000));
        }
        this.reservoir = new WeightedDoubleReservoirSample((int)maxSamples);
    }

    private WeightedReservoirSampleStateStrategy(WeightedReservoirSampleStateStrategy other) {
        this.reservoir = other.reservoir.clone();
    }

    private WeightedReservoirSampleStateStrategy(WeightedDoubleReservoirSample reservoir) {
        this.reservoir = reservoir;
    }

    @Override
    public void validateParameters(long maxSamples, double sample, double weight) {
        if (weight < 0.0) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("In differential_entropy UDF, weight must be non-negative: %s", weight));
        }
        if (maxSamples != this.reservoir.getMaxSamples()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("In differential_entropy UDF, inconsistent maxSamples: %s, %s", maxSamples, this.reservoir.getMaxSamples()));
        }
    }

    @Override
    public void mergeWith(DifferentialEntropyStateStrategy other) {
        Verify.verify((boolean)(other instanceof WeightedReservoirSampleStateStrategy), (String)String.format("class should be an instance of WeightedReservoirSampleStateStrategy: %s", other.getClass().getSimpleName()), (Object[])new Object[0]);
        this.reservoir.mergeWith(((WeightedReservoirSampleStateStrategy)other).reservoir);
    }

    @Override
    public void add(double value, double weight) {
        this.reservoir.add(value, weight);
    }

    @Override
    public double getTotalPopulationWeight() {
        return this.reservoir.getTotalPopulationWeight();
    }

    @Override
    public double calculateEntropy() {
        return EntropyCalculations.calculateFromSamplesUsingVasicek(this.reservoir.getSamples());
    }

    @Override
    public long getEstimatedSize() {
        return this.reservoir.estimatedInMemorySize();
    }

    @Override
    public int getRequiredBytesForSpecificSerialization() {
        return this.reservoir.getRequiredBytesForSerialization();
    }

    public static WeightedReservoirSampleStateStrategy deserialize(SliceInput input) {
        return new WeightedReservoirSampleStateStrategy(WeightedDoubleReservoirSample.deserialize(input));
    }

    @Override
    public void serialize(SliceOutput out) {
        this.reservoir.serialize(out);
    }

    @Override
    public DifferentialEntropyStateStrategy clone() {
        return new WeightedReservoirSampleStateStrategy(this);
    }

    @Override
    public DifferentialEntropyStateStrategy cloneEmpty() {
        return new WeightedReservoirSampleStateStrategy(this.reservoir.getMaxSamples());
    }
}

