/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.operator.scalar.ArrayMinMaxUtils;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.OperatorDependency;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlNullable;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeParameter;
import com.facebook.presto.util.Failures;
import io.airlift.slice.Slice;
import java.lang.invoke.MethodHandle;

@ScalarFunction(value="array_min")
@Description(value="Get minimum value of array")
public final class ArrayMinFunction {
    private ArrayMinFunction() {
    }

    @TypeParameter(value="T")
    @SqlType(value="T")
    @SqlNullable
    public static Long longArrayMin(@OperatorDependency(operator=OperatorType.LESS_THAN, argumentTypes={"T", "T"}) MethodHandle compareMethodHandle, @TypeParameter(value="T") Type elementType, @SqlType(value="array(T)") Block block) {
        return ArrayMinMaxUtils.longArrayMinMax(compareMethodHandle, elementType, block);
    }

    @TypeParameter(value="T")
    @SqlType(value="T")
    @SqlNullable
    public static Boolean booleanArrayMin(@OperatorDependency(operator=OperatorType.LESS_THAN, argumentTypes={"T", "T"}) MethodHandle compareMethodHandle, @TypeParameter(value="T") Type elementType, @SqlType(value="array(T)") Block block) {
        return ArrayMinMaxUtils.booleanArrayMinMax(compareMethodHandle, elementType, block);
    }

    @TypeParameter(value="T")
    @SqlType(value="T")
    @SqlNullable
    public static Double doubleArrayMin(@OperatorDependency(operator=OperatorType.LESS_THAN, argumentTypes={"T", "T"}) MethodHandle compareMethodHandle, @TypeParameter(value="T") Type elementType, @SqlType(value="array(T)") Block block) {
        return ArrayMinMaxUtils.doubleArrayMinMax(compareMethodHandle, elementType, block);
    }

    @TypeParameter(value="T")
    @SqlType(value="T")
    @SqlNullable
    public static Slice sliceArrayMin(@OperatorDependency(operator=OperatorType.LESS_THAN, argumentTypes={"T", "T"}) MethodHandle compareMethodHandle, @TypeParameter(value="T") Type elementType, @SqlType(value="array(T)") Block block) {
        return ArrayMinMaxUtils.sliceArrayMinMax(compareMethodHandle, elementType, block);
    }

    @TypeParameter(value="T")
    @SqlType(value="T")
    @SqlNullable
    public static Block blockArrayMin(@OperatorDependency(operator=OperatorType.LESS_THAN, argumentTypes={"T", "T"}) MethodHandle compareMethodHandle, @TypeParameter(value="T") Type elementType, @SqlType(value="array(T)") Block block) {
        try {
            if (block.getPositionCount() == 0) {
                return null;
            }
            Block selectedValue = (Block)elementType.getObject(block, 0);
            for (int i = 0; i < block.getPositionCount(); ++i) {
                if (block.isNull(i)) {
                    return null;
                }
                Block value = (Block)elementType.getObject(block, i);
                if (!compareMethodHandle.invokeExact(value, selectedValue)) continue;
                selectedValue = value;
            }
            return selectedValue;
        }
        catch (Throwable t) {
            throw Failures.internalError(t);
        }
    }
}

