/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeParameter;
import java.util.concurrent.ThreadLocalRandom;

@ScalarFunction(value="shuffle", deterministic=false)
@Description(value="Generates a random permutation of the given array.")
public final class ArrayShuffleFunction {
    private static final int INITIAL_LENGTH = 128;

    @TypeParameter(value="E")
    public ArrayShuffleFunction(@TypeParameter(value="E") Type elementType) {
    }

    @TypeParameter(value="E")
    @SqlType(value="array(E)")
    public Block shuffle(@TypeParameter(value="E") Type type, @SqlType(value="array(E)") Block block) {
        int i;
        int length = block.getPositionCount();
        int[] positions = new int[length];
        for (i = 0; i < length; ++i) {
            positions[i] = i;
        }
        for (i = length - 1; i > 0; --i) {
            int index = ThreadLocalRandom.current().nextInt(i + 1);
            int swap = positions[i];
            positions[i] = positions[index];
            positions[index] = swap;
        }
        BlockBuilder blockBuilder = type.createBlockBuilder(null, block.getPositionCount());
        for (int i2 = 0; i2 < length; ++i2) {
            type.appendTo(block, positions[i2], blockBuilder);
        }
        return blockBuilder.build();
    }
}

