/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.Chars;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.LiteralParameters;
import com.facebook.presto.spi.function.ScalarOperator;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.type.LiteralParameter;
import io.airlift.jcodings.Encoding;
import io.airlift.jcodings.specific.NonStrictUTF8Encoding;
import io.airlift.joni.Regex;
import io.airlift.joni.Syntax;
import io.airlift.slice.Slice;

public final class JoniRegexpCasts {
    private JoniRegexpCasts() {
    }

    @LiteralParameters(value={"x"})
    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="JoniRegExp")
    public static Regex castVarcharToJoniRegexp(@SqlType(value="varchar(x)") Slice pattern) {
        return JoniRegexpCasts.joniRegexp(pattern);
    }

    @ScalarOperator(value=OperatorType.CAST)
    @LiteralParameters(value={"x"})
    @SqlType(value="JoniRegExp")
    public static Regex castCharToJoniRegexp(@LiteralParameter(value="x") Long charLength, @SqlType(value="char(x)") Slice pattern) {
        return JoniRegexpCasts.joniRegexp(Chars.padSpaces((Slice)pattern, (int)charLength.intValue()));
    }

    public static Regex joniRegexp(Slice pattern) {
        Regex regex;
        try {
            regex = new Regex(pattern.getBytes(), 0, pattern.length(), 0, (Encoding)NonStrictUTF8Encoding.INSTANCE, Syntax.Java);
        }
        catch (Exception e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, (Throwable)e);
        }
        return regex;
    }
}

