/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.unnest;

import com.facebook.presto.common.array.Arrays;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.ColumnarMap;
import com.facebook.presto.operator.unnest.UnnestBlockBuilder;
import com.facebook.presto.operator.unnest.Unnester;
import io.airlift.slice.SizeOf;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

class MapUnnester
implements Unnester {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(MapUnnester.class).instanceSize();
    private final UnnestBlockBuilder keyUnnestBlockBuilder;
    private final UnnestBlockBuilder valueUnnestBlockBuilder;
    private int[] lengths = new int[0];
    private ColumnarMap columnarMap;

    public MapUnnester() {
        this.keyUnnestBlockBuilder = new UnnestBlockBuilder();
        this.valueUnnestBlockBuilder = new UnnestBlockBuilder();
    }

    @Override
    public int getChannelCount() {
        return 2;
    }

    @Override
    public void resetInput(Block block) {
        Objects.requireNonNull(block, "block is null");
        this.columnarMap = ColumnarMap.toColumnarMap((Block)block);
        this.keyUnnestBlockBuilder.resetInputBlock(this.columnarMap.getKeysBlock());
        this.valueUnnestBlockBuilder.resetInputBlock(this.columnarMap.getValuesBlock());
        int positionCount = block.getPositionCount();
        this.lengths = Arrays.ensureCapacity((int[])this.lengths, (int)positionCount);
        for (int i = 0; i < positionCount; ++i) {
            this.lengths[i] = this.columnarMap.getEntryCount(i);
        }
    }

    @Override
    public int[] getLengths() {
        return this.lengths;
    }

    @Override
    public Block[] buildOutputBlocks(int[] maxLengths, int startPosition, int batchSize, int currentBatchTotalLength) {
        boolean nullRequired = this.needToInsertNulls(startPosition, batchSize, currentBatchTotalLength);
        Block[] outputBlocks = new Block[2];
        if (nullRequired) {
            outputBlocks[0] = this.keyUnnestBlockBuilder.buildOutputBlockWithNulls(maxLengths, startPosition, batchSize, currentBatchTotalLength, this.lengths);
            outputBlocks[1] = this.valueUnnestBlockBuilder.buildOutputBlockWithNulls(maxLengths, startPosition, batchSize, currentBatchTotalLength, this.lengths);
        } else {
            outputBlocks[0] = this.keyUnnestBlockBuilder.buildOutputBlockWithoutNulls(currentBatchTotalLength);
            outputBlocks[1] = this.valueUnnestBlockBuilder.buildOutputBlockWithoutNulls(currentBatchTotalLength);
        }
        return outputBlocks;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.sizeOf((int[])this.lengths);
    }

    private boolean needToInsertNulls(int offset, int length, int maxTotalEntriesForBatch) {
        int totalEntriesForBatch = this.columnarMap.getOffset(offset + length) - this.columnarMap.getOffset(offset);
        return totalEntriesForBatch < maxTotalEntriesForBatch;
    }
}

