/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.unnest;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.DictionaryBlock;
import com.google.common.base.Verify;
import java.util.Objects;
import javax.annotation.Nullable;

class UnnestBlockBuilder {
    private final NullElementFinder nullFinder = new NullElementFinder();
    private Block source;
    private int sourcePosition;
    private Block nullCheckBlock;
    private int nullCheckBlockPosition;

    UnnestBlockBuilder() {
    }

    public void resetInputBlock(Block block) {
        this.resetInputBlock(block, null);
    }

    public void resetInputBlock(Block block, @Nullable Block nullCheckBlock) {
        this.source = Objects.requireNonNull(block, "block is null");
        this.nullFinder.resetCheck(block);
        this.sourcePosition = 0;
        this.nullCheckBlock = nullCheckBlock;
        this.nullCheckBlockPosition = 0;
    }

    public Block buildOutputBlockWithoutNulls(int outputPositionCount) {
        Block output = this.source.getRegion(this.sourcePosition, outputPositionCount);
        this.sourcePosition += outputPositionCount;
        return output;
    }

    public Block buildOutputBlockWithNulls(int[] maxLengths, int offset, int length, int outputPositionCount, int[] lengths) {
        if (this.nullFinder.getNullElementIndex() == -1) {
            this.source = this.source.appendNull();
            this.nullFinder.setNullElementIndex(this.source.getPositionCount() - 1);
        }
        return this.buildOutputBlockWithNullsByDictionary(maxLengths, offset, length, outputPositionCount, this.nullFinder.getNullElementIndex(), lengths);
    }

    protected Block buildOutputBlockWithNullsByDictionary(int[] maxLengths, int offset, int length, int outputPositionCount, int nullIndex, int[] lengths) {
        Verify.verify((nullIndex != -1 ? 1 : 0) != 0, (String)"nullIndex is -1", (Object[])new Object[0]);
        int position = 0;
        int[] ids = new int[outputPositionCount];
        for (int i = 0; i < length; ++i) {
            int j;
            int entryCount = lengths[offset + i];
            if (this.nullCheckBlock == null) {
                for (j = 0; j < entryCount; ++j) {
                    ids[position++] = this.sourcePosition++;
                }
            } else {
                for (j = 0; j < entryCount; ++j) {
                    ids[position++] = this.nullCheckBlock.isNull(this.nullCheckBlockPosition++) ? nullIndex : this.sourcePosition++;
                }
            }
            int maxEntryCount = maxLengths[offset + i];
            for (int j2 = entryCount; j2 < maxEntryCount; ++j2) {
                ids[position++] = nullIndex;
            }
        }
        return new DictionaryBlock(outputPositionCount, this.source, ids);
    }

    static class NullElementFinder {
        static final int NULL_NOT_FOUND = -1;
        private boolean checkedForNull;
        private int nullElementPosition = -1;
        private Block source;

        NullElementFinder() {
        }

        void resetCheck(Block source) {
            this.checkedForNull = false;
            this.nullElementPosition = -1;
            this.source = Objects.requireNonNull(source);
        }

        public int getNullElementIndex() {
            if (this.checkedForNull) {
                return this.nullElementPosition;
            }
            this.checkForNull();
            return this.nullElementPosition;
        }

        public void setNullElementIndex(int nullElementPosition) {
            this.nullElementPosition = nullElementPosition;
            this.checkedForNull = true;
        }

        private void checkForNull() {
            this.nullElementPosition = -1;
            this.checkedForNull = true;
            if (!this.source.mayHaveNull()) {
                return;
            }
            for (int i = 0; i < this.source.getPositionCount(); ++i) {
                if (!this.source.isNull(i)) continue;
                this.nullElementPosition = i;
                break;
            }
        }
    }
}

