/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.resourcemanager;

import com.facebook.drift.client.DriftClient;
import com.facebook.presto.memory.LocalMemoryManager;
import com.facebook.presto.memory.NodeMemoryConfig;
import com.facebook.presto.resourcemanager.ForResourceManager;
import com.facebook.presto.resourcemanager.ResourceManagerClient;
import com.facebook.presto.resourcemanager.ResourceManagerConfig;
import com.facebook.presto.spi.memory.ClusterMemoryPoolInfo;
import com.facebook.presto.spi.memory.MemoryPoolId;
import com.facebook.presto.spi.memory.MemoryPoolInfo;
import com.facebook.presto.util.PeriodicTaskExecutor;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;

public class ClusterMemoryManagerService {
    private static final ClusterMemoryPoolInfo EMPTY_MEMORY_POOL = new ClusterMemoryPoolInfo(new MemoryPoolInfo(0L, 0L, 0L, (Map)ImmutableMap.of(), (Map)ImmutableMap.of(), (Map)ImmutableMap.of()), 0, 0);
    private final DriftClient<ResourceManagerClient> resourceManagerClient;
    private final ScheduledExecutorService executorService;
    private final AtomicReference<Map<MemoryPoolId, ClusterMemoryPoolInfo>> memoryPools;
    private final long memoryPoolFetchIntervalMillis;
    private final boolean isReservedPoolEnabled;
    private final PeriodicTaskExecutor memoryPoolUpdater;

    @Inject
    public ClusterMemoryManagerService(@ForResourceManager DriftClient<ResourceManagerClient> resourceManagerClient, @ForResourceManager ScheduledExecutorService executorService, ResourceManagerConfig resourceManagerConfig, NodeMemoryConfig nodeMemoryConfig) {
        this.resourceManagerClient = Objects.requireNonNull(resourceManagerClient, "resourceManagerClient is null");
        this.executorService = Objects.requireNonNull(executorService, "executorService is null");
        this.memoryPoolFetchIntervalMillis = Objects.requireNonNull(resourceManagerConfig, "resourceManagerConfig is null").getMemoryPoolFetchInterval().toMillis();
        this.isReservedPoolEnabled = Objects.requireNonNull(nodeMemoryConfig, "nodeMemoryConfig is null").isReservedPoolEnabled();
        ImmutableMap.Builder defaultPoolBuilder = ImmutableMap.builder().put((Object)LocalMemoryManager.GENERAL_POOL, (Object)EMPTY_MEMORY_POOL);
        if (this.isReservedPoolEnabled) {
            defaultPoolBuilder.put((Object)LocalMemoryManager.RESERVED_POOL, (Object)EMPTY_MEMORY_POOL);
        }
        this.memoryPools = new AtomicReference<ImmutableMap>(defaultPoolBuilder.build());
        this.memoryPoolUpdater = new PeriodicTaskExecutor(this.memoryPoolFetchIntervalMillis, executorService, () -> this.memoryPools.set(this.updateMemoryPoolInfo()));
    }

    @PostConstruct
    public void init() {
        this.memoryPoolUpdater.start();
    }

    @PreDestroy
    public void stop() {
        this.memoryPoolUpdater.stop();
    }

    public Map<MemoryPoolId, ClusterMemoryPoolInfo> getMemoryPoolInfo() {
        return this.memoryPools.get();
    }

    private Map<MemoryPoolId, ClusterMemoryPoolInfo> updateMemoryPoolInfo() {
        Map<MemoryPoolId, ClusterMemoryPoolInfo> memoryPoolInfos = ((ResourceManagerClient)this.resourceManagerClient.get()).getMemoryPoolInfo();
        memoryPoolInfos.putIfAbsent(LocalMemoryManager.GENERAL_POOL, EMPTY_MEMORY_POOL);
        if (this.isReservedPoolEnabled) {
            memoryPoolInfos.putIfAbsent(LocalMemoryManager.RESERVED_POOL, EMPTY_MEMORY_POOL);
        }
        return ImmutableMap.copyOf(memoryPoolInfos);
    }
}

