/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.resourcemanager;

import com.facebook.airlift.http.client.HttpClient;
import com.facebook.airlift.http.client.JsonResponseHandler;
import com.facebook.airlift.http.client.Request;
import com.facebook.airlift.http.client.ResponseHandler;
import com.facebook.airlift.http.client.UnexpectedResponseException;
import com.facebook.airlift.json.JsonCodec;
import com.facebook.airlift.log.Logger;
import com.facebook.presto.metadata.InternalNode;
import com.facebook.presto.metadata.InternalNodeManager;
import com.facebook.presto.resourcemanager.AggregatedResourceGroupInfoBuilder;
import com.facebook.presto.resourcemanager.ForResourceManager;
import com.facebook.presto.server.ResourceGroupInfo;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.io.IOException;
import java.net.URI;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import javax.annotation.security.RolesAllowed;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Encoded;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="/v1/resourceGroupState")
@RolesAllowed(value={"admin"})
public class DistributedResourceGroupInfoResource {
    private static final Logger log = Logger.get(DistributedResourceGroupInfoResource.class);
    private final InternalNodeManager internalNodeManager;
    private final ListeningExecutorService executor;
    private final HttpClient httpClient;
    private final JsonCodec<ResourceGroupInfo> jsonCodec;

    @Inject
    public DistributedResourceGroupInfoResource(InternalNodeManager internalNodeManager, @ForResourceManager ListeningExecutorService executor, @ForResourceManager HttpClient httpClient, JsonCodec<ResourceGroupInfo> jsonCodec) {
        this.internalNodeManager = Objects.requireNonNull(internalNodeManager, "internalNodeManager is null");
        this.executor = Objects.requireNonNull(executor, "executor is null");
        this.httpClient = Objects.requireNonNull(httpClient, "httpClient is null");
        this.jsonCodec = Objects.requireNonNull(jsonCodec, "jsonCodec is null");
    }

    @GET
    @Produces(value={"application/json"})
    @Encoded
    @Path(value="{resourceGroupId: .+}")
    public void getResourceGroupInfos(@PathParam(value="resourceGroupId") String resourceGroupIdString, @Context UriInfo uriInfo, @Context HttpServletRequest servletRequest, @Suspended AsyncResponse asyncResponse) {
        if (Strings.isNullOrEmpty((String)resourceGroupIdString)) {
            asyncResponse.resume((Object)Response.status((Response.Status)Response.Status.NOT_FOUND).build());
        }
        try {
            ImmutableList.Builder resourceGroupInfoFutureBuilder = ImmutableList.builder();
            for (InternalNode coordinator : this.internalNodeManager.getCoordinators()) {
                resourceGroupInfoFutureBuilder.add(this.getResourceGroupInfoFromCoordinator(uriInfo, coordinator));
            }
            ImmutableList resourceGroupInfoFutureList = resourceGroupInfoFutureBuilder.build();
            Futures.whenAllComplete((Iterable)resourceGroupInfoFutureList).call(() -> this.lambda$getResourceGroupInfos$0((List)resourceGroupInfoFutureList, asyncResponse), (Executor)this.executor);
        }
        catch (IOException ex) {
            log.error((Throwable)ex, "Error in getting resource group info");
            asyncResponse.resume((Object)Response.serverError().entity((Object)ex.getMessage()).build());
        }
    }

    private ResourceGroupInfo aggregateResourceGroupInfo(List<ListenableFuture<ResourceGroupInfo>> queryStateInfoFutureList) throws InterruptedException, ExecutionException {
        Iterator<ListenableFuture<ResourceGroupInfo>> iterator = queryStateInfoFutureList.iterator();
        AggregatedResourceGroupInfoBuilder builder = new AggregatedResourceGroupInfoBuilder();
        while (iterator.hasNext()) {
            try {
                builder.add((ResourceGroupInfo)iterator.next().get());
            }
            catch (ExecutionException e) {
                Throwable exceptionCause = e.getCause();
                if (exceptionCause instanceof UnexpectedResponseException && ((UnexpectedResponseException)exceptionCause).getStatusCode() == Response.Status.NOT_FOUND.getStatusCode()) continue;
                throw e;
            }
        }
        return builder.build();
    }

    private ListenableFuture<ResourceGroupInfo> getResourceGroupInfoFromCoordinator(UriInfo uriInfo, InternalNode coordinatorNode) throws IOException {
        String scheme = uriInfo.getRequestUri().getScheme();
        URI uri = uriInfo.getRequestUriBuilder().queryParam("includeLocalInfoOnly", new Object[]{true}).scheme(scheme).host(coordinatorNode.getHostAndPort().toInetAddress().getHostName()).port(coordinatorNode.getInternalUri().getPort()).build(new Object[0]);
        Request request = Request.Builder.prepareGet().setUri(uri).build();
        return this.httpClient.executeAsync(request, (ResponseHandler)JsonResponseHandler.createJsonResponseHandler(this.jsonCodec));
    }

    private /* synthetic */ Boolean lambda$getResourceGroupInfos$0(List resourceGroupInfoFutureList, @Suspended AsyncResponse asyncResponse) throws Exception {
        try {
            ResourceGroupInfo aggregatedResourceGroupInfo = this.aggregateResourceGroupInfo(resourceGroupInfoFutureList);
            if (aggregatedResourceGroupInfo == null) {
                return asyncResponse.resume((Object)Response.status((Response.Status)Response.Status.NOT_FOUND).build());
            }
            return asyncResponse.resume((Object)Response.ok((Object)aggregatedResourceGroupInfo).build());
        }
        catch (Exception ex) {
            log.error((Throwable)ex, "Error in getting resource group info from one of the coordinators");
            return asyncResponse.resume((Object)Response.serverError().entity((Object)ex.getMessage()).build());
        }
    }
}

