/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.airlift.http.client.Request;
import com.google.common.net.MediaType;

public class RequestHelpers {
    private RequestHelpers() {
    }

    public static Request.Builder setContentTypeHeaders(boolean isBinaryTransportEnabled, Request.Builder requestBuilder) {
        if (isBinaryTransportEnabled) {
            return RequestHelpers.getBinaryTransportBuilder(requestBuilder);
        }
        return RequestHelpers.getJsonTransportBuilder(requestBuilder);
    }

    public static Request.Builder getBinaryTransportBuilder(Request.Builder requestBuilder) {
        return requestBuilder.setHeader("Content-Type", "application/x-jackson-smile").setHeader("Accept", "application/x-jackson-smile");
    }

    public static Request.Builder getJsonTransportBuilder(Request.Builder requestBuilder) {
        return requestBuilder.setHeader("Content-Type", MediaType.JSON_UTF_8.toString()).setHeader("Accept", MediaType.JSON_UTF_8.toString());
    }
}

