/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.presto.execution.QueryManager;
import com.facebook.presto.execution.StageInfo;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.TaskInfo;
import com.facebook.presto.spi.QueryId;
import com.google.inject.Inject;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;

@Path(value="v1/taskInfo")
@RolesAllowed(value={"ADMIN"})
public class TaskInfoResource {
    private final QueryManager queryManager;

    @Inject
    public TaskInfoResource(QueryManager queryManager) {
        this.queryManager = Objects.requireNonNull(queryManager, "queryManager is null");
    }

    @GET
    @Path(value="{taskId}")
    public TaskInfo getTaskInfo(@PathParam(value="taskId") TaskId taskId) throws NotFoundException {
        QueryId queryId = taskId.getQueryId();
        try {
            Optional<TaskInfo> taskInfo;
            Optional<StageInfo> stage;
            Optional<StageInfo> stageInfo = this.queryManager.getFullQueryInfo(queryId).getOutputStage();
            if (stageInfo.isPresent() && (stage = stageInfo.get().getStageWithStageId(taskId.getStageExecutionId().getStageId())).isPresent() && (taskInfo = stage.get().getLatestAttemptExecutionInfo().getTasks().stream().filter(info -> info.getTaskId().equals(taskId)).findFirst()).isPresent()) {
                return taskInfo.get();
            }
            throw new NotFoundException("TaskInfo not found for task id " + taskId.toString());
        }
        catch (Exception e) {
            throw new NotFoundException((Throwable)e);
        }
    }
}

