/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server.thrift;

import com.facebook.airlift.concurrent.Threads;
import com.facebook.drift.annotations.ThriftMethod;
import com.facebook.drift.annotations.ThriftService;
import com.facebook.presto.server.GracefulShutdownHandler;
import com.facebook.presto.spi.NodeState;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.inject.Inject;

@ThriftService(value="presto-info", idlName="ThriftServerInfoService")
public class ThriftServerInfoService {
    private final GracefulShutdownHandler shutdownHandler;
    private final ListeningExecutorService executor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newSingleThreadExecutor(Threads.daemonThreadsNamed((String)"server-info-executor")));

    @Inject
    public ThriftServerInfoService(GracefulShutdownHandler shutdownHandler) {
        this.shutdownHandler = Objects.requireNonNull(shutdownHandler, "shutdownHandler is null");
    }

    @ThriftMethod
    public ListenableFuture<Integer> getServerState() {
        return this.executor.submit(() -> {
            if (this.shutdownHandler.isShutdownRequested()) {
                return NodeState.SHUTTING_DOWN.getValue();
            }
            return NodeState.ACTIVE.getValue();
        });
    }
}

