/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spiller;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.io.DataOutput;
import com.facebook.presto.execution.buffer.PageSplitterUtil;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.page.PageDataOutput;
import com.facebook.presto.spi.page.PagesSerde;
import com.facebook.presto.spi.page.PagesSerdeUtil;
import com.facebook.presto.spi.page.SerializedPage;
import com.facebook.presto.spi.storage.SerializedStorageHandle;
import com.facebook.presto.spi.storage.TempDataOperationContext;
import com.facebook.presto.spi.storage.TempDataSink;
import com.facebook.presto.spi.storage.TempStorage;
import com.facebook.presto.spi.storage.TempStorageHandle;
import com.facebook.presto.spiller.SpillerStats;
import com.facebook.presto.spiller.StandaloneSpiller;
import com.google.common.collect.Iterators;
import io.airlift.slice.InputStreamSliceInput;
import io.airlift.slice.SliceInput;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class TempStorageStandaloneSpiller
implements StandaloneSpiller {
    private final TempDataOperationContext tempDataOperationContext;
    private final TempStorage tempStorage;
    private final PagesSerde serde;
    private final SpillerStats spillerStats;
    private final int maxBufferSizeInBytes;

    public TempStorageStandaloneSpiller(TempDataOperationContext tempDataOperationContext, TempStorage tempStorage, PagesSerde serde, SpillerStats spillerStats, int maxBufferSizeInBytes) {
        this.tempDataOperationContext = Objects.requireNonNull(tempDataOperationContext, "tempDataOperationContext is null");
        this.tempStorage = Objects.requireNonNull(tempStorage, "tempStorage is null");
        this.serde = Objects.requireNonNull(serde, "serde is null");
        this.spillerStats = Objects.requireNonNull(spillerStats, "spillerStats is null");
        this.maxBufferSizeInBytes = maxBufferSizeInBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SerializedStorageHandle spill(Iterator<Page> pageIterator) {
        ArrayList<DataOutput> bufferedPages = new ArrayList<DataOutput>();
        int bufferedBytes = 0;
        IOException ioException = null;
        TempDataSink tempDataSink = null;
        try {
            SerializedStorageHandle splitPages;
            tempDataSink = this.tempStorage.create(this.tempDataOperationContext);
            while (pageIterator.hasNext()) {
                Page page = pageIterator.next();
                splitPages = PageSplitterUtil.splitPage(page, 0x100000L);
                for (Page splitPage : splitPages) {
                    SerializedPage serializedPage = this.serde.serialize(splitPage);
                    this.spillerStats.addToTotalSpilledBytes(serializedPage.getSizeInBytes());
                    PageDataOutput pageDataOutput = new PageDataOutput(serializedPage);
                    bufferedPages.add((DataOutput)pageDataOutput);
                    if ((bufferedBytes += Math.toIntExact(pageDataOutput.size())) <= this.maxBufferSizeInBytes) continue;
                    this.flushBufferedPages(tempDataSink, bufferedPages);
                    bufferedBytes = 0;
                }
            }
            if (!bufferedPages.isEmpty()) {
                this.flushBufferedPages(tempDataSink, bufferedPages);
            }
            TempStorageHandle tempStorageHandle = tempDataSink.commit();
            splitPages = new SerializedStorageHandle(this.tempStorage.serializeHandle(tempStorageHandle));
            return splitPages;
        }
        catch (IOException e) {
            ioException = e;
            try {
                if (tempDataSink != null) {
                    tempDataSink.rollback();
                }
            }
            catch (IOException exception) {
                if (ioException != exception) {
                    ioException.addSuppressed(exception);
                }
            }
        }
        finally {
            try {
                if (tempDataSink != null) {
                    tempDataSink.close();
                }
            }
            catch (IOException e) {
                if (ioException == null) {
                    ioException = e;
                } else if (ioException != e) {
                    ioException.addSuppressed(e);
                }
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_SPILL_FAILURE, "Failed to spill pages", (Throwable)ioException);
            }
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_SPILL_FAILURE, "Failed to spill pages", (Throwable)ioException);
    }

    private void flushBufferedPages(TempDataSink tempDataSink, List<DataOutput> bufferedPages) {
        try {
            tempDataSink.write(bufferedPages);
        }
        catch (IOException | UncheckedIOException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_SPILL_FAILURE, "Failed to spill pages", (Throwable)e);
        }
        bufferedPages.clear();
    }

    @Override
    public Iterator<Page> getSpilledPages(SerializedStorageHandle storageHandle) {
        try {
            TempStorageHandle tempStorageHandle = this.tempStorage.deserialize(storageHandle.getSerializedStorageHandle());
            InputStream inputStream = this.tempStorage.open(this.tempDataOperationContext, tempStorageHandle);
            Iterator deserializedPages = PagesSerdeUtil.readPages((PagesSerde)this.serde, (SliceInput)new InputStreamSliceInput(inputStream));
            return Iterators.transform((Iterator)deserializedPages, Page::compact);
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_SPILL_FAILURE, "Failed to read spilled pages", (Throwable)e);
        }
    }

    @Override
    public void remove(SerializedStorageHandle storageHandle) {
        try {
            this.tempStorage.remove(this.tempDataOperationContext, this.tempStorage.deserialize(storageHandle.getSerializedStorageHandle()));
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_SPILL_FAILURE, "Failed to delete spill file", (Throwable)e);
        }
    }
}

