/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql;

import com.facebook.presto.Session;
import com.facebook.presto.common.predicate.NullableValue;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.SessionPropertyManager;
import com.facebook.presto.spi.MaterializedViewStatus;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.security.Identity;
import com.facebook.presto.sql.planner.LiteralEncoder;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Identifier;
import com.facebook.presto.sql.tree.IsNullPredicate;
import com.facebook.presto.sql.tree.LogicalBinaryExpression;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;

public class MaterializedViewUtils {
    private MaterializedViewUtils() {
    }

    public static Session buildOwnerSession(Session session, Optional<String> owner, SessionPropertyManager sessionPropertyManager, String catalog, String schema) {
        Identity identity = MaterializedViewUtils.getOwnerIdentity(owner, session);
        return Session.builder(sessionPropertyManager).setQueryId(session.getQueryId()).setTransactionId(session.getTransactionId().orElse(null)).setIdentity(identity).setSource(session.getSource().orElse(null)).setCatalog(catalog).setSchema(schema).setTimeZoneKey(session.getTimeZoneKey()).setLocale(session.getLocale()).setRemoteUserAddress(session.getRemoteUserAddress().orElse(null)).setUserAgent(session.getUserAgent().orElse(null)).setClientInfo(session.getClientInfo().orElse(null)).setStartTime(session.getStartTime()).build();
    }

    public static Identity getOwnerIdentity(Optional<String> owner, Session session) {
        if (owner.isPresent() && !owner.get().equals(session.getIdentity().getUser())) {
            return new Identity(owner.get(), Optional.empty());
        }
        return session.getIdentity();
    }

    public static Map<SchemaTableName, Expression> generateBaseTablePredicates(Map<SchemaTableName, MaterializedViewStatus.MaterializedDataPredicates> predicatesFromBaseTables, Metadata metadata) {
        HashMap<SchemaTableName, Expression> baseTablePredicates = new HashMap<SchemaTableName, Expression>();
        for (SchemaTableName baseTable : predicatesFromBaseTables.keySet()) {
            MaterializedViewStatus.MaterializedDataPredicates predicatesInfo = predicatesFromBaseTables.get(baseTable);
            List partitionKeys = predicatesInfo.getColumnNames();
            ImmutableList keyExpressions = (ImmutableList)partitionKeys.stream().map(Identifier::new).collect(ImmutableList.toImmutableList());
            List predicateDisjuncts = predicatesInfo.getPredicateDisjuncts();
            BooleanLiteral disjunct = null;
            for (TupleDomain predicateDisjunct : predicateDisjuncts) {
                IsNullPredicate conjunct = null;
                Iterator keyExpressionsIterator = keyExpressions.stream().iterator();
                Map predicateKeyValue = (Map)TupleDomain.extractFixedValues((TupleDomain)predicateDisjunct).orElseThrow(() -> new IllegalStateException("predicateKeyValue is not present!"));
                for (String key : partitionKeys) {
                    IsNullPredicate expression;
                    NullableValue nullableValue = (NullableValue)predicateKeyValue.get(key);
                    if (nullableValue.isNull()) {
                        expression = new IsNullPredicate((Expression)keyExpressionsIterator.next());
                    } else {
                        LiteralEncoder literalEncoder = new LiteralEncoder(metadata.getBlockEncodingSerde());
                        Expression valueExpression = literalEncoder.toExpression(nullableValue.getValue(), nullableValue.getType(), false);
                        expression = new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)keyExpressionsIterator.next(), valueExpression);
                    }
                    conjunct = conjunct == null ? expression : new LogicalBinaryExpression(LogicalBinaryExpression.Operator.AND, (Expression)conjunct, (Expression)expression);
                }
                disjunct = conjunct == null ? disjunct : (disjunct == null ? conjunct : new LogicalBinaryExpression(LogicalBinaryExpression.Operator.OR, (Expression)disjunct, conjunct));
            }
            if (disjunct == null) {
                disjunct = BooleanLiteral.FALSE_LITERAL;
            }
            baseTablePredicates.put(baseTable, (Expression)disjunct);
        }
        return baseTablePredicates;
    }

    public static Map<SchemaTableName, Expression> generateFalsePredicates(List<SchemaTableName> baseTables) {
        return (Map)baseTables.stream().collect(ImmutableMap.toImmutableMap(table -> table, table -> BooleanLiteral.FALSE_LITERAL));
    }

    public static <T> Map<T, Set<T>> transitiveClosure(Map<T, Set<T>> graph) {
        ImmutableMap.Builder closure = ImmutableMap.builder();
        for (T node : graph.keySet()) {
            HashSet visited = new HashSet();
            Stack stack = new Stack();
            stack.push(node);
            while (!stack.empty()) {
                Object current = stack.pop();
                if (visited.contains(current)) continue;
                visited.add(current);
                ((Set)graph.getOrDefault(current, (Set<T>)ImmutableSet.of())).forEach(neighbor -> stack.push(neighbor));
            }
            closure.put(node, visited);
        }
        return closure.build();
    }
}

