/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.presto.sql.analyzer.Analysis;
import com.facebook.presto.sql.analyzer.FieldId;
import com.facebook.presto.sql.analyzer.Scope;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeRef;
import com.facebook.presto.sql.util.AstUtils;
import com.google.common.collect.Multimap;
import java.util.Objects;
import java.util.stream.Stream;

class ScopeReferenceExtractor {
    private ScopeReferenceExtractor() {
    }

    public static boolean hasReferencesToScope(Node node, Analysis analysis, Scope scope) {
        return ScopeReferenceExtractor.getReferencesToScope(node, analysis, scope).findAny().isPresent();
    }

    public static Stream<Expression> getReferencesToScope(Node node, Analysis analysis, Scope scope) {
        Multimap<NodeRef<Expression>, FieldId> columnReferences = analysis.getColumnReferenceFields();
        return AstUtils.preOrder((Node)node).filter(Expression.class::isInstance).map(Expression.class::cast).filter(expression -> columnReferences.containsKey((Object)NodeRef.of((Node)expression))).filter(expression -> ScopeReferenceExtractor.hasReferenceToScope(expression, scope, columnReferences));
    }

    private static boolean hasReferenceToScope(Expression node, Scope scope, Multimap<NodeRef<Expression>, FieldId> columnReferences) {
        return columnReferences.get((Object)NodeRef.of((Node)node)).stream().anyMatch(fieldId -> ScopeReferenceExtractor.isFieldFromScope(fieldId, scope));
    }

    public static boolean isFieldFromScope(FieldId fieldId, Scope scope) {
        return Objects.equals(fieldId.getRelationId(), scope.getRelationId());
    }
}

