/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.sql.analyzer.Analysis;
import com.facebook.presto.sql.analyzer.Field;
import com.facebook.presto.sql.analyzer.FieldId;
import com.facebook.presto.sql.analyzer.RelationId;
import com.facebook.presto.sql.tree.AliasedRelation;
import com.facebook.presto.sql.tree.Cube;
import com.facebook.presto.sql.tree.DefaultTraversalVisitor;
import com.facebook.presto.sql.tree.DereferenceExpression;
import com.facebook.presto.sql.tree.Except;
import com.facebook.presto.sql.tree.ExistsPredicate;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FieldReference;
import com.facebook.presto.sql.tree.GroupingSets;
import com.facebook.presto.sql.tree.Identifier;
import com.facebook.presto.sql.tree.InPredicate;
import com.facebook.presto.sql.tree.Intersect;
import com.facebook.presto.sql.tree.Join;
import com.facebook.presto.sql.tree.JoinCriteria;
import com.facebook.presto.sql.tree.JoinOn;
import com.facebook.presto.sql.tree.JoinUsing;
import com.facebook.presto.sql.tree.LambdaArgumentDeclaration;
import com.facebook.presto.sql.tree.LambdaExpression;
import com.facebook.presto.sql.tree.Lateral;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeRef;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.QuerySpecification;
import com.facebook.presto.sql.tree.Relation;
import com.facebook.presto.sql.tree.Rollup;
import com.facebook.presto.sql.tree.SampledRelation;
import com.facebook.presto.sql.tree.SubqueryExpression;
import com.facebook.presto.sql.tree.Table;
import com.facebook.presto.sql.tree.TableSubquery;
import com.facebook.presto.sql.tree.Union;
import com.facebook.presto.sql.tree.Unnest;
import com.facebook.presto.sql.tree.Values;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UtilizedColumnsAnalyzer {
    private static final Logger LOG = Logger.get(UtilizedColumnsAnalyzer.class);
    private final Analysis analysis;

    public static void analyzeForUtilizedColumns(Analysis analysis, Node node) {
        UtilizedColumnsAnalyzer analyzer = new UtilizedColumnsAnalyzer(analysis);
        try {
            analyzer.analyze(node);
        }
        catch (Exception e) {
            LOG.debug((Throwable)e, String.format("Error in analyzing utilized columns, falling back to access control on all columns: %s", analysis.getStatement()));
            analysis.getTableColumnReferences().forEach(analysis::addUtilizedTableColumnReferences);
        }
    }

    public UtilizedColumnsAnalyzer(Analysis analysis) {
        this.analysis = analysis;
    }

    public void analyze(Node node) {
        UtilizedFieldsBuilderVisitor visitor = new UtilizedFieldsBuilderVisitor(this.analysis);
        ImmutableSet.Builder utilizedFieldsBuilder = ImmutableSet.builder();
        visitor.process(node, new Context(utilizedFieldsBuilder));
        HashMultimap utilizedTableColumns = HashMultimap.create();
        for (Field field : utilizedFieldsBuilder.build()) {
            if (!field.getOriginTable().isPresent() || !field.getOriginColumnName().isPresent()) continue;
            utilizedTableColumns.put((Object)field.getOriginTable().get(), (Object)field.getOriginColumnName().get());
        }
        for (Map.Entry entry : this.analysis.getTableColumnReferences().entrySet()) {
            Analysis.AccessControlInfo accessControlInfo = (Analysis.AccessControlInfo)entry.getKey();
            Map tableColumnsForThisAccessControl = (Map)entry.getValue();
            HashMap<QualifiedObjectName, Set<String>> utilizedTableColumnsForThisAccessControl = new HashMap<QualifiedObjectName, Set<String>>();
            for (QualifiedObjectName table : tableColumnsForThisAccessControl.keySet()) {
                utilizedTableColumnsForThisAccessControl.put(table, (Set<String>)Sets.intersection((Set)utilizedTableColumns.get((Object)table), (Set)((Set)tableColumnsForThisAccessControl.get(table))));
            }
            this.analysis.addUtilizedTableColumnReferences(accessControlInfo, utilizedTableColumnsForThisAccessControl);
        }
    }

    private static class Context {
        ImmutableSet.Builder<Field> utilizedFieldsBuilder;
        HashMultimap<RelationId, FieldId> fieldsToExplore;
        boolean prunable;

        private static Context newPrunableContext(Context context) {
            return new Context(context.utilizedFieldsBuilder, context.fieldsToExplore, true);
        }

        private static Context newUnprunableContext(Context context) {
            return new Context(context.utilizedFieldsBuilder, context.fieldsToExplore, false);
        }

        private Context(ImmutableSet.Builder<Field> utilizedFieldsBuilder) {
            this(utilizedFieldsBuilder, (HashMultimap<RelationId, FieldId>)HashMultimap.create(), false);
        }

        private Context(ImmutableSet.Builder<Field> utilizedFieldsBuilder, HashMultimap<RelationId, FieldId> fieldsToExplore, boolean prunable) {
            this.utilizedFieldsBuilder = utilizedFieldsBuilder;
            this.fieldsToExplore = fieldsToExplore;
            this.prunable = prunable;
        }

        private Set<FieldId> getFieldIdsToExploreInRelation(Relation relation) {
            return this.fieldsToExplore.get((Object)RelationId.of((Node)relation));
        }

        private void addUtilizedField(Field field) {
            this.utilizedFieldsBuilder.add((Object)field);
        }

        private void addFieldIdToExplore(FieldId fieldId) {
            this.fieldsToExplore.put((Object)fieldId.getRelationId(), (Object)fieldId);
        }
    }

    private static class UtilizedFieldsBuilderVisitor
    extends DefaultTraversalVisitor<Void, Context> {
        private final Analysis analysis;

        private UtilizedFieldsBuilderVisitor(Analysis analysis) {
            this.analysis = analysis;
        }

        protected Void visitAliasedRelation(AliasedRelation aliasedRelation, Context context) {
            this.handleRelation((Relation)aliasedRelation, context, aliasedRelation.getRelation());
            this.process((Node)aliasedRelation.getRelation(), context);
            return null;
        }

        protected Void visitExcept(Except except, Context context) {
            this.handleRelation((Relation)except, context, except.getLeft(), except.getRight());
            this.process((Node)except.getLeft(), context);
            this.process((Node)except.getRight(), context);
            return null;
        }

        protected Void visitIntersect(Intersect intersect, Context context) {
            this.handleRelation((Relation)intersect, context, intersect.getRelations().toArray(new Relation[0]));
            for (Relation relation : intersect.getRelations()) {
                this.process((Node)relation, context);
            }
            return null;
        }

        protected Void visitJoin(Join join, Context context) {
            this.handleRelation((Relation)join, context, new Relation[0]);
            if (join.getCriteria().isPresent()) {
                JoinCriteria joinCriteria = (JoinCriteria)join.getCriteria().get();
                if (joinCriteria instanceof JoinOn) {
                    this.process((Node)((JoinOn)joinCriteria).getExpression(), context);
                } else if (joinCriteria instanceof JoinUsing) {
                    for (Identifier column : ((JoinUsing)joinCriteria).getColumns()) {
                        this.process((Node)column, context);
                    }
                }
            }
            int numLeftFields = this.analysis.getScope((Node)join.getLeft()).getRelationType().getAllFieldCount();
            for (FieldId fieldId : context.getFieldIdsToExploreInRelation((Relation)join)) {
                if (fieldId.getFieldIndex() < numLeftFields) {
                    context.addFieldIdToExplore(new FieldId(RelationId.of((Node)join.getLeft()), fieldId.getFieldIndex()));
                    continue;
                }
                context.addFieldIdToExplore(new FieldId(RelationId.of((Node)join.getRight()), fieldId.getFieldIndex() - numLeftFields));
            }
            this.process((Node)join.getRight(), context);
            this.process((Node)join.getLeft(), context);
            return null;
        }

        protected Void visitLateral(Lateral lateral, Context context) {
            this.handleRelation((Relation)lateral, context, new Relation[]{lateral.getQuery().getQueryBody()});
            this.process((Node)lateral.getQuery(), context);
            return null;
        }

        protected Void visitQuery(Query query, Context context) {
            this.process((Node)query.getQueryBody(), context);
            if (query.getOrderBy().isPresent()) {
                this.process((Node)query.getOrderBy().get(), context);
            }
            if (query.getWith().isPresent()) {
                this.process((Node)query.getWith().get(), Context.newPrunableContext(context));
            }
            return null;
        }

        protected Void visitQuerySpecification(QuerySpecification querySpec, Context context) {
            this.handleRelation((Relation)querySpec, context, new Relation[0]);
            List<Expression> selectItems = this.analysis.getOutputExpressions((Node)querySpec);
            if (!context.prunable) {
                for (Expression expression : selectItems) {
                    this.process((Node)expression, context);
                }
            } else {
                for (FieldId fieldId : context.getFieldIdsToExploreInRelation((Relation)querySpec)) {
                    this.process((Node)selectItems.get(fieldId.getFieldIndex()), context);
                }
            }
            Context unprunableContext = Context.newUnprunableContext(context);
            if (querySpec.getWhere().isPresent()) {
                this.process((Node)querySpec.getWhere().get(), unprunableContext);
            }
            if (querySpec.getGroupBy().isPresent()) {
                this.process((Node)querySpec.getGroupBy().get(), unprunableContext);
            }
            if (querySpec.getHaving().isPresent()) {
                this.process((Node)querySpec.getHaving().get(), unprunableContext);
            }
            if (querySpec.getOrderBy().isPresent()) {
                this.process((Node)querySpec.getOrderBy().get(), context);
            }
            if (querySpec.getFrom().isPresent()) {
                this.process((Node)querySpec.getFrom().get(), Context.newPrunableContext(context));
            }
            return null;
        }

        protected Void visitSampledRelation(SampledRelation sampledRelation, Context context) {
            this.handleRelation((Relation)sampledRelation, context, sampledRelation.getRelation());
            this.process((Node)sampledRelation.getSamplePercentage(), context);
            this.process((Node)sampledRelation.getRelation(), context);
            return null;
        }

        protected Void visitTable(Table table, Context context) {
            this.handleRelation((Relation)table, context, new Relation[0]);
            return null;
        }

        protected Void visitTableSubquery(TableSubquery tableSubquery, Context context) {
            this.handleRelation((Relation)tableSubquery, context, new Relation[]{tableSubquery.getQuery().getQueryBody()});
            this.process((Node)tableSubquery.getQuery(), context);
            return null;
        }

        protected Void visitUnion(Union union, Context context) {
            this.handleRelation((Relation)union, context, union.getRelations().toArray(new Relation[0]));
            for (Relation relation : union.getRelations()) {
                this.process((Node)relation, context);
            }
            return null;
        }

        protected Void visitUnnest(Unnest unnest, Context context) {
            this.handleRelation((Relation)unnest, context, new Relation[0]);
            for (FieldId fieldId : context.getFieldIdsToExploreInRelation((Relation)unnest)) {
                this.process((Node)unnest.getExpressions().get(fieldId.getFieldIndex()), context);
            }
            return null;
        }

        protected Void visitValues(Values values, Context context) {
            this.handleRelation((Relation)values, context, new Relation[0]);
            for (Expression row : values.getRows()) {
                this.process((Node)row, context);
            }
            return null;
        }

        protected Void visitExists(ExistsPredicate existsPredicate, Context context) {
            super.visitExists(existsPredicate, (Object)Context.newPrunableContext(context));
            return null;
        }

        protected Void visitInPredicate(InPredicate inPredicate, Context context) {
            super.visitInPredicate(inPredicate, (Object)Context.newUnprunableContext(context));
            return null;
        }

        protected Void visitSubqueryExpression(SubqueryExpression subqueryExpression, Context context) {
            super.visitSubqueryExpression(subqueryExpression, (Object)(this.analysis.isScalarSubquery(subqueryExpression) ? Context.newUnprunableContext(context) : context));
            return null;
        }

        protected Void visitLambdaExpression(LambdaExpression lambdaExpression, Context context) {
            for (LambdaArgumentDeclaration arg : lambdaExpression.getArguments()) {
                this.process((Node)arg, context);
            }
            this.process((Node)lambdaExpression.getBody(), context);
            return null;
        }

        protected Void visitCube(Cube cube, Context context) {
            for (Expression expr : cube.getExpressions()) {
                this.process((Node)expr, context);
            }
            return null;
        }

        protected Void visitRollup(Rollup rollup, Context context) {
            for (Expression expr : rollup.getExpressions()) {
                this.process((Node)expr, context);
            }
            return null;
        }

        protected Void visitGroupingSets(GroupingSets groupingSets, Context context) {
            for (Expression expr : groupingSets.getExpressions()) {
                this.process((Node)expr, context);
            }
            return null;
        }

        protected Void visitDereferenceExpression(DereferenceExpression dereferenceExpression, Context context) {
            this.handleExpression((Expression)dereferenceExpression, context);
            this.process((Node)dereferenceExpression.getBase(), context);
            return null;
        }

        protected Void visitIdentifier(Identifier identifier, Context context) {
            this.handleExpression((Expression)identifier, context);
            return null;
        }

        protected Void visitFieldReference(FieldReference fieldReference, Context context) {
            this.handleExpression((Expression)fieldReference, context);
            return null;
        }

        private void handleRelation(Relation relation, Context context, Relation ... children) {
            for (FieldId fieldId : context.getFieldIdsToExploreInRelation(relation)) {
                context.addUtilizedField(this.analysis.getScope((Node)relation).getRelationType().getFieldByIndex(fieldId.getFieldIndex()));
                for (Relation child : children) {
                    context.addFieldIdToExplore(new FieldId(RelationId.of((Node)child), fieldId.getFieldIndex()));
                }
            }
        }

        private void handleExpression(Expression expression, Context context) {
            if (this.analysis.getColumnReferenceFields().containsKey((Object)NodeRef.of((Node)expression))) {
                this.analysis.getColumnReferenceFields().get((Object)NodeRef.of((Node)expression)).forEach(x$0 -> context.addFieldIdToExplore(x$0));
            }
        }
    }
}

