/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.Variable;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementationChoice;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.function.JavaScalarFunctionImplementation;
import com.facebook.presto.spi.function.ScalarFunctionImplementation;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.sql.gen.BytecodeGeneratorContext;
import com.facebook.presto.sql.gen.BytecodeUtils;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class FunctionCallCodeGenerator {
    public BytecodeNode generateCall(FunctionHandle functionHandle, BytecodeGeneratorContext context, Type returnType, List<RowExpression> arguments, Optional<Variable> outputBlockVariable) {
        FunctionAndTypeManager functionAndTypeManager = context.getFunctionManager();
        ScalarFunctionImplementation function = functionAndTypeManager.getScalarFunctionImplementation(functionHandle);
        Preconditions.checkArgument((boolean)(function instanceof JavaScalarFunctionImplementation), (Object)String.format("FunctionCallCodeGenerator only handles JavaScalarFunctionImplementation, get %s", function.getClass().getName()));
        JavaScalarFunctionImplementation javaFunction = (JavaScalarFunctionImplementation)function;
        ArrayList<BytecodeNode> argumentsBytecode = new ArrayList<BytecodeNode>();
        ScalarFunctionImplementationChoice choice = BytecodeUtils.getAllScalarFunctionImplementationChoices(javaFunction).get(0);
        for (int i = 0; i < arguments.size(); ++i) {
            RowExpression argument = arguments.get(i);
            ScalarFunctionImplementationChoice.ArgumentProperty argumentProperty = choice.getArgumentProperty(i);
            if (argumentProperty.getArgumentType() == ScalarFunctionImplementationChoice.ArgumentType.VALUE_TYPE) {
                argumentsBytecode.add(context.generate(argument, Optional.empty()));
                continue;
            }
            argumentsBytecode.add(context.generate(argument, Optional.empty(), Optional.of(argumentProperty.getLambdaInterface())));
        }
        return context.generateCall(functionAndTypeManager.getFunctionMetadata(functionHandle).getName().getObjectName(), javaFunction, argumentsBytecode, outputBlockVariable.map(variable -> new BytecodeUtils.OutputBlockVariableAndType((Variable)variable, returnType)));
    }
}

