/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ConnectorPlanOptimizer;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.connector.ConnectorPlanOptimizerProvider;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;

public class ConnectorPlanOptimizerManager {
    private final Map<ConnectorId, ConnectorPlanOptimizerProvider> planOptimizerProviders = new ConcurrentHashMap<ConnectorId, ConnectorPlanOptimizerProvider>();

    @Inject
    public ConnectorPlanOptimizerManager() {
    }

    public void addPlanOptimizerProvider(ConnectorId connectorId, ConnectorPlanOptimizerProvider planOptimizerProvider) {
        Objects.requireNonNull(connectorId, "connectorId is null");
        Objects.requireNonNull(planOptimizerProvider, "planOptimizerProvider is null");
        Preconditions.checkArgument((this.planOptimizerProviders.putIfAbsent(connectorId, planOptimizerProvider) == null ? 1 : 0) != 0, (String)"ConnectorPlanOptimizerProvider for connector '%s' is already registered", (Object)connectorId);
    }

    public void removePlanOptimizerProvider(ConnectorId connectorId) {
        Objects.requireNonNull(connectorId, "connectorId is null");
        this.planOptimizerProviders.remove(connectorId);
    }

    public Map<ConnectorId, Set<ConnectorPlanOptimizer>> getOptimizers(PlanPhase phase) {
        switch (phase) {
            case LOGICAL: {
                return ImmutableMap.copyOf((Map)Maps.transformValues(this.planOptimizerProviders, ConnectorPlanOptimizerProvider::getLogicalPlanOptimizers));
            }
            case PHYSICAL: {
                return ImmutableMap.copyOf((Map)Maps.transformValues(this.planOptimizerProviders, ConnectorPlanOptimizerProvider::getPhysicalPlanOptimizers));
            }
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Unknown plan phase " + (Object)((Object)phase));
    }

    public static enum PlanPhase {
        LOGICAL,
        PHYSICAL;

    }
}

