/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.cost.CachingCostProvider;
import com.facebook.presto.cost.CachingStatsProvider;
import com.facebook.presto.cost.CostCalculator;
import com.facebook.presto.cost.StatsAndCosts;
import com.facebook.presto.cost.StatsCalculator;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.metadata.NewTableLayout;
import com.facebook.presto.metadata.TableMetadata;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.Assignments;
import com.facebook.presto.spi.plan.LimitNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.plan.ValuesNode;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.spi.statistics.TableStatisticType;
import com.facebook.presto.spi.statistics.TableStatisticsMetadata;
import com.facebook.presto.sql.analyzer.Analysis;
import com.facebook.presto.sql.analyzer.ExpressionTreeUtils;
import com.facebook.presto.sql.analyzer.Field;
import com.facebook.presto.sql.analyzer.RelationId;
import com.facebook.presto.sql.analyzer.RelationType;
import com.facebook.presto.sql.analyzer.Scope;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.Partitioning;
import com.facebook.presto.sql.planner.PartitioningScheme;
import com.facebook.presto.sql.planner.Plan;
import com.facebook.presto.sql.planner.PlanVariableAllocator;
import com.facebook.presto.sql.planner.QueryPlanner;
import com.facebook.presto.sql.planner.RelationPlan;
import com.facebook.presto.sql.planner.RelationPlanner;
import com.facebook.presto.sql.planner.StatisticsAggregationPlanner;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.optimizations.PlanNodeSearcher;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.plan.DeleteNode;
import com.facebook.presto.sql.planner.plan.ExplainAnalyzeNode;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.OutputNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.planner.plan.StatisticAggregations;
import com.facebook.presto.sql.planner.plan.StatisticsWriterNode;
import com.facebook.presto.sql.planner.plan.TableFinishNode;
import com.facebook.presto.sql.planner.plan.TableWriterNode;
import com.facebook.presto.sql.planner.sanity.PlanChecker;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.relational.OriginalExpressionUtils;
import com.facebook.presto.sql.tree.Analyze;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.CreateTableAsSelect;
import com.facebook.presto.sql.tree.Delete;
import com.facebook.presto.sql.tree.Explain;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Identifier;
import com.facebook.presto.sql.tree.Insert;
import com.facebook.presto.sql.tree.LambdaArgumentDeclaration;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeLocation;
import com.facebook.presto.sql.tree.NodeRef;
import com.facebook.presto.sql.tree.NullLiteral;
import com.facebook.presto.sql.tree.Parameter;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.RefreshMaterializedView;
import com.facebook.presto.sql.tree.Statement;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class LogicalPlanner {
    private final boolean explain;
    private final PlanNodeIdAllocator idAllocator;
    private final Session session;
    private final List<PlanOptimizer> planOptimizers;
    private final PlanChecker planChecker;
    private final PlanVariableAllocator variableAllocator = new PlanVariableAllocator();
    private final Metadata metadata;
    private final SqlParser sqlParser;
    private final StatisticsAggregationPlanner statisticsAggregationPlanner;
    private final StatsCalculator statsCalculator;
    private final CostCalculator costCalculator;
    private final WarningCollector warningCollector;

    public LogicalPlanner(boolean explain, Session session, List<PlanOptimizer> planOptimizers, PlanNodeIdAllocator idAllocator, Metadata metadata, SqlParser sqlParser, StatsCalculator statsCalculator, CostCalculator costCalculator, WarningCollector warningCollector, PlanChecker planChecker) {
        this(explain, session, planOptimizers, planChecker, idAllocator, metadata, sqlParser, statsCalculator, costCalculator, warningCollector);
    }

    public LogicalPlanner(boolean explain, Session session, List<PlanOptimizer> planOptimizers, PlanChecker planChecker, PlanNodeIdAllocator idAllocator, Metadata metadata, SqlParser sqlParser, StatsCalculator statsCalculator, CostCalculator costCalculator, WarningCollector warningCollector) {
        this.explain = explain;
        this.session = Objects.requireNonNull(session, "session is null");
        this.planOptimizers = Objects.requireNonNull(planOptimizers, "planOptimizers is null");
        this.planChecker = Objects.requireNonNull(planChecker, "planChecker is null");
        this.idAllocator = Objects.requireNonNull(idAllocator, "idAllocator is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
        this.statisticsAggregationPlanner = new StatisticsAggregationPlanner(this.variableAllocator, metadata);
        this.statsCalculator = Objects.requireNonNull(statsCalculator, "statsCalculator is null");
        this.costCalculator = Objects.requireNonNull(costCalculator, "costCalculator is null");
        this.warningCollector = Objects.requireNonNull(warningCollector, "warningCollector is null");
    }

    public Plan plan(Analysis analysis) {
        return this.plan(analysis, Stage.OPTIMIZED_AND_VALIDATED);
    }

    public Plan plan(Analysis analysis, Stage stage) {
        PlanNode root = this.planStatement(analysis, analysis.getStatement());
        this.planChecker.validateIntermediatePlan(root, this.session, this.metadata, this.sqlParser, this.variableAllocator.getTypes(), this.warningCollector);
        boolean enableVerboseRuntimeStats = SystemSessionProperties.isVerboseRuntimeStatsEnabled(this.session);
        if (stage.ordinal() >= Stage.OPTIMIZED.ordinal()) {
            for (PlanOptimizer optimizer : this.planOptimizers) {
                long start = System.nanoTime();
                root = optimizer.optimize(root, this.session, this.variableAllocator.getTypes(), this.variableAllocator, this.idAllocator, this.warningCollector);
                Objects.requireNonNull(root, String.format("%s returned a null plan", optimizer.getClass().getName()));
                if (!enableVerboseRuntimeStats) continue;
                this.session.getRuntimeStats().addMetricValue(String.format("optimizer%sTimeNanos", optimizer.getClass().getSimpleName()), System.nanoTime() - start);
            }
        }
        if (stage.ordinal() >= Stage.OPTIMIZED_AND_VALIDATED.ordinal()) {
            this.planChecker.validateFinalPlan(root, this.session, this.metadata, this.sqlParser, this.variableAllocator.getTypes(), this.warningCollector);
        }
        TypeProvider types = this.variableAllocator.getTypes();
        return new Plan(root, types, this.computeStats(root, types));
    }

    private StatsAndCosts computeStats(PlanNode root, TypeProvider types) {
        if (this.explain || SystemSessionProperties.isPrintStatsForNonJoinQuery(this.session) || PlanNodeSearcher.searchFrom(root).where(node -> node instanceof JoinNode || node instanceof SemiJoinNode).matches()) {
            CachingStatsProvider statsProvider = new CachingStatsProvider(this.statsCalculator, this.session, types);
            CachingCostProvider costProvider = new CachingCostProvider(this.costCalculator, statsProvider, Optional.empty(), this.session);
            return StatsAndCosts.create(root, statsProvider, costProvider);
        }
        return StatsAndCosts.empty();
    }

    public PlanNode planStatement(Analysis analysis, Statement statement) {
        if (statement instanceof CreateTableAsSelect && analysis.isCreateTableAsSelectNoOp()) {
            Preconditions.checkState((boolean)analysis.getCreateTableDestination().isPresent(), (Object)"Table destination is missing");
            VariableReferenceExpression variable = this.variableAllocator.newVariable(ExpressionTreeUtils.getSourceLocation((Node)statement), "rows", (Type)BigintType.BIGINT);
            ValuesNode source = new ValuesNode(ExpressionTreeUtils.getSourceLocation((Node)statement), this.idAllocator.getNextId(), (List)ImmutableList.of((Object)variable), (List)ImmutableList.of((Object)ImmutableList.of((Object)Expressions.constant(0L, (Type)BigintType.BIGINT))));
            return new OutputNode(source.getSourceLocation(), this.idAllocator.getNextId(), (PlanNode)source, (List<String>)ImmutableList.of((Object)"rows"), (List<VariableReferenceExpression>)ImmutableList.of((Object)variable));
        }
        return this.createOutputPlan(this.planStatementWithoutOutput(analysis, statement), analysis);
    }

    private RelationPlan planStatementWithoutOutput(Analysis analysis, Statement statement) {
        if (statement instanceof CreateTableAsSelect) {
            if (analysis.isCreateTableAsSelectNoOp()) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "CREATE TABLE IF NOT EXISTS is not supported in this context " + statement.getClass().getSimpleName());
            }
            return this.createTableCreationPlan(analysis, ((CreateTableAsSelect)statement).getQuery());
        }
        if (statement instanceof Analyze) {
            return this.createAnalyzePlan(analysis, (Analyze)statement);
        }
        if (statement instanceof Insert) {
            Preconditions.checkState((boolean)analysis.getInsert().isPresent(), (Object)"Insert handle is missing");
            return this.createInsertPlan(analysis, (Insert)statement);
        }
        if (statement instanceof Delete) {
            return this.createDeletePlan(analysis, (Delete)statement);
        }
        if (statement instanceof Query) {
            return this.createRelationPlan(analysis, (Query)statement);
        }
        if (statement instanceof Explain && ((Explain)statement).isAnalyze()) {
            return this.createExplainAnalyzePlan(analysis, (Explain)statement);
        }
        if (statement instanceof RefreshMaterializedView) {
            Preconditions.checkState((boolean)analysis.getRefreshMaterializedViewAnalysis().isPresent(), (Object)"RefreshMaterializedView analysis is missing");
            return this.createRefreshMaterializedViewPlan(analysis, (RefreshMaterializedView)statement);
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported statement type " + statement.getClass().getSimpleName());
    }

    private RelationPlan createExplainAnalyzePlan(Analysis analysis, Explain statement) {
        RelationPlan underlyingPlan = this.planStatementWithoutOutput(analysis, statement.getStatement());
        PlanNode root = underlyingPlan.getRoot();
        Scope scope = analysis.getScope((Node)statement);
        VariableReferenceExpression outputVariable = this.variableAllocator.newVariable(scope.getRelationType().getFieldByIndex(0));
        root = new ExplainAnalyzeNode(ExpressionTreeUtils.getSourceLocation((Node)statement), this.idAllocator.getNextId(), root, outputVariable, statement.isVerbose());
        return new RelationPlan(root, scope, (List<VariableReferenceExpression>)ImmutableList.of((Object)outputVariable));
    }

    private RelationPlan createAnalyzePlan(Analysis analysis, Analyze analyzeStatement) {
        TableHandle targetTable = analysis.getAnalyzeTarget().get();
        Map<String, ColumnHandle> columnHandles = this.metadata.getColumnHandles(this.session, targetTable);
        ImmutableList.Builder tableScanOutputsBuilder = ImmutableList.builder();
        ImmutableMap.Builder variableToColumnHandle = ImmutableMap.builder();
        ImmutableMap.Builder columnNameToVariable = ImmutableMap.builder();
        TableMetadata tableMetadata = this.metadata.getTableMetadata(this.session, targetTable);
        for (ColumnMetadata column : tableMetadata.getColumns()) {
            VariableReferenceExpression variable = this.variableAllocator.newVariable(ExpressionTreeUtils.getSourceLocation((Node)analyzeStatement), column.getName(), column.getType());
            tableScanOutputsBuilder.add((Object)variable);
            variableToColumnHandle.put((Object)variable, (Object)columnHandles.get(column.getName()));
            columnNameToVariable.put((Object)column.getName(), (Object)variable);
        }
        ImmutableList tableScanOutputs = tableScanOutputsBuilder.build();
        TableStatisticsMetadata tableStatisticsMetadata = this.metadata.getStatisticsCollectionMetadata(this.session, targetTable.getConnectorId().getCatalogName(), tableMetadata.getMetadata());
        StatisticsAggregationPlanner.TableStatisticAggregation tableStatisticAggregation = this.statisticsAggregationPlanner.createStatisticsAggregation(tableStatisticsMetadata, (Map<String, VariableReferenceExpression>)columnNameToVariable.build(), true);
        StatisticAggregations statisticAggregations = tableStatisticAggregation.getAggregations();
        StatisticsWriterNode planNode = new StatisticsWriterNode(ExpressionTreeUtils.getSourceLocation((Node)analyzeStatement), this.idAllocator.getNextId(), (PlanNode)new AggregationNode(ExpressionTreeUtils.getSourceLocation((Node)analyzeStatement), this.idAllocator.getNextId(), (PlanNode)new TableScanNode(ExpressionTreeUtils.getSourceLocation((Node)analyzeStatement), this.idAllocator.getNextId(), targetTable, (List)tableScanOutputs, (Map)variableToColumnHandle.build(), TupleDomain.all(), TupleDomain.all()), statisticAggregations.getAggregations(), AggregationNode.singleGroupingSet(statisticAggregations.getGroupingVariables()), (List)ImmutableList.of(), AggregationNode.Step.SINGLE, Optional.empty(), Optional.empty()), targetTable, this.variableAllocator.newVariable(ExpressionTreeUtils.getSourceLocation((Node)analyzeStatement), "rows", (Type)BigintType.BIGINT), tableStatisticsMetadata.getTableStatistics().contains(TableStatisticType.ROW_COUNT), tableStatisticAggregation.getDescriptor());
        return new RelationPlan(planNode, analysis.getScope((Node)analyzeStatement), planNode.getOutputVariables());
    }

    private RelationPlan createTableCreationPlan(Analysis analysis, Query query) {
        QualifiedObjectName destination = analysis.getCreateTableDestination().get();
        RelationPlan plan = this.createRelationPlan(analysis, query);
        ConnectorTableMetadata tableMetadata = this.createTableMetadata(destination, LogicalPlanner.getOutputTableColumns(plan, analysis.getColumnAliases()), analysis.getCreateTableProperties(), analysis.getParameters(), analysis.getCreateTableComment());
        Optional<NewTableLayout> newTableLayout = this.metadata.getNewTableLayout(this.session, destination.getCatalogName(), tableMetadata);
        Optional<NewTableLayout> preferredShuffleLayout = this.metadata.getPreferredShuffleLayoutForNewTable(this.session, destination.getCatalogName(), tableMetadata);
        List columnNames = (List)tableMetadata.getColumns().stream().filter(column -> !column.isHidden()).map(ColumnMetadata::getName).collect(ImmutableList.toImmutableList());
        TableStatisticsMetadata statisticsMetadata = this.metadata.getStatisticsCollectionMetadataForWrite(this.session, destination.getCatalogName(), tableMetadata);
        return this.createTableWriterPlan(analysis, plan, new TableWriterNode.CreateName(new ConnectorId(destination.getCatalogName()), tableMetadata, newTableLayout), columnNames, tableMetadata.getColumns(), newTableLayout, preferredShuffleLayout, statisticsMetadata);
    }

    private RelationPlan createRefreshMaterializedViewPlan(Analysis analysis, RefreshMaterializedView refreshMaterializedViewStatement) {
        Analysis.RefreshMaterializedViewAnalysis viewAnalysis = analysis.getRefreshMaterializedViewAnalysis().get();
        TableHandle tableHandle = viewAnalysis.getTarget();
        List<ColumnHandle> columnHandles = viewAnalysis.getColumns();
        TableWriterNode.RefreshMaterializedViewReference target = new TableWriterNode.RefreshMaterializedViewReference(tableHandle, this.metadata.getTableMetadata(this.session, tableHandle).getTable());
        return this.buildInternalInsertPlan(tableHandle, columnHandles, viewAnalysis.getQuery(), analysis, target);
    }

    private RelationPlan createInsertPlan(Analysis analysis, Insert insertStatement) {
        Analysis.Insert insertAnalysis = analysis.getInsert().get();
        TableHandle tableHandle = insertAnalysis.getTarget();
        List<ColumnHandle> columnHandles = insertAnalysis.getColumns();
        TableWriterNode.InsertReference target = new TableWriterNode.InsertReference(tableHandle, this.metadata.getTableMetadata(this.session, tableHandle).getTable());
        return this.buildInternalInsertPlan(tableHandle, columnHandles, insertStatement.getQuery(), analysis, target);
    }

    private RelationPlan buildInternalInsertPlan(TableHandle tableHandle, List<ColumnHandle> columnHandles, Query query, Analysis analysis, TableWriterNode.WriterTarget target) {
        TableMetadata tableMetadata = this.metadata.getTableMetadata(this.session, tableHandle);
        List visibleTableColumns = (List)tableMetadata.getColumns().stream().filter(column -> !column.isHidden()).collect(ImmutableList.toImmutableList());
        List visibleTableColumnNames = (List)visibleTableColumns.stream().map(ColumnMetadata::getName).collect(ImmutableList.toImmutableList());
        RelationPlan plan = this.createRelationPlan(analysis, query);
        Map<String, ColumnHandle> columns = this.metadata.getColumnHandles(this.session, tableHandle);
        Assignments.Builder assignments = Assignments.builder();
        for (ColumnMetadata column2 : tableMetadata.getColumns()) {
            if (column2.isHidden()) continue;
            VariableReferenceExpression output = this.variableAllocator.newVariable(ExpressionTreeUtils.getSourceLocation((Node)query), column2.getName(), column2.getType());
            int index = columnHandles.indexOf(columns.get(column2.getName()));
            if (index < 0) {
                Cast cast = new Cast((Expression)new NullLiteral(), column2.getType().getTypeSignature().toString());
                assignments.put(output, OriginalExpressionUtils.castToRowExpression((Expression)cast));
                continue;
            }
            VariableReferenceExpression input = plan.getVariable(index);
            Type tableType = column2.getType();
            Type queryType = input.getType();
            if (queryType.equals(tableType) || this.metadata.getFunctionAndTypeManager().isTypeOnlyCoercion(queryType, tableType)) {
                assignments.put(output, OriginalExpressionUtils.castToRowExpression((Expression)ExpressionTreeUtils.createSymbolReference(input)));
                continue;
            }
            Cast cast = new Cast((Expression)ExpressionTreeUtils.createSymbolReference(input), tableType.getTypeSignature().toString());
            assignments.put(output, OriginalExpressionUtils.castToRowExpression((Expression)cast));
        }
        ProjectNode projectNode = new ProjectNode(this.idAllocator.getNextId(), plan.getRoot(), assignments.build());
        List fields = (List)visibleTableColumns.stream().map(column -> Field.newUnqualified((Optional<NodeLocation>)query.getLocation(), column.getName(), column.getType())).collect(ImmutableList.toImmutableList());
        Scope scope = Scope.builder().withRelationType(RelationId.anonymous(), new RelationType(fields)).build();
        plan = new RelationPlan((PlanNode)projectNode, scope, projectNode.getOutputVariables());
        Optional<NewTableLayout> newTableLayout = this.metadata.getInsertLayout(this.session, tableHandle);
        Optional<NewTableLayout> preferredShuffleLayout = this.metadata.getPreferredShuffleLayoutForInsert(this.session, tableHandle);
        String catalogName = tableHandle.getConnectorId().getCatalogName();
        TableStatisticsMetadata statisticsMetadata = this.metadata.getStatisticsCollectionMetadataForWrite(this.session, catalogName, tableMetadata.getMetadata());
        return this.createTableWriterPlan(analysis, plan, target, visibleTableColumnNames, visibleTableColumns, newTableLayout, preferredShuffleLayout, statisticsMetadata);
    }

    private RelationPlan createTableWriterPlan(Analysis analysis, RelationPlan plan, TableWriterNode.WriterTarget target, List<String> columnNames, List<ColumnMetadata> columnMetadataList, Optional<NewTableLayout> writeTableLayout, Optional<NewTableLayout> preferredShuffleLayout, TableStatisticsMetadata statisticsMetadata) {
        Verify.verify((!writeTableLayout.isPresent() || !preferredShuffleLayout.isPresent() ? 1 : 0) != 0, (String)"writeTableLayout and preferredShuffleLayout cannot both exist", (Object[])new Object[0]);
        PlanNode source = plan.getRoot();
        if (!analysis.isCreateTableAsSelectWithData()) {
            source = new LimitNode(source.getSourceLocation(), this.idAllocator.getNextId(), source, 0L, LimitNode.Step.FINAL);
        }
        List<VariableReferenceExpression> variables = plan.getFieldMappings();
        Optional<PartitioningScheme> tablePartitioningScheme = LogicalPlanner.getPartitioningSchemeForTableWrite(writeTableLayout, columnNames, variables);
        Optional<PartitioningScheme> preferredShufflePartitioningScheme = LogicalPlanner.getPartitioningSchemeForTableWrite(preferredShuffleLayout, columnNames, variables);
        Verify.verify((columnNames.size() == variables.size() ? 1 : 0) != 0, (String)"columnNames.size() != variables.size(): %s and %s", columnNames, variables);
        Map columnToVariableMap = (Map)Streams.zip(columnNames.stream(), plan.getFieldMappings().stream(), AbstractMap.SimpleImmutableEntry::new).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
        Set notNullColumnVariables = (Set)columnMetadataList.stream().filter(column -> !column.isNullable()).map(ColumnMetadata::getName).map(columnToVariableMap::get).collect(ImmutableSet.toImmutableSet());
        if (!statisticsMetadata.isEmpty()) {
            StatisticsAggregationPlanner.TableStatisticAggregation result = this.statisticsAggregationPlanner.createStatisticsAggregation(statisticsMetadata, columnToVariableMap, true);
            StatisticAggregations.Parts aggregations = result.getAggregations().splitIntoPartialAndFinal(this.variableAllocator, this.metadata.getFunctionAndTypeManager());
            TableFinishNode commitNode = new TableFinishNode(source.getSourceLocation(), this.idAllocator.getNextId(), new TableWriterNode(source.getSourceLocation(), this.idAllocator.getNextId(), source, Optional.of(target), this.variableAllocator.newVariable("rows", (Type)BigintType.BIGINT), this.variableAllocator.newVariable("fragments", (Type)VarbinaryType.VARBINARY), this.variableAllocator.newVariable("commitcontext", (Type)VarbinaryType.VARBINARY), plan.getFieldMappings(), columnNames, notNullColumnVariables, tablePartitioningScheme, preferredShufflePartitioningScheme, Optional.of(aggregations.getPartialAggregation())), Optional.of(target), this.variableAllocator.newVariable("rows", (Type)BigintType.BIGINT), Optional.of(aggregations.getFinalAggregation()), Optional.of(result.getDescriptor()));
            return new RelationPlan(commitNode, analysis.getRootScope(), commitNode.getOutputVariables());
        }
        TableFinishNode commitNode = new TableFinishNode(source.getSourceLocation(), this.idAllocator.getNextId(), new TableWriterNode(source.getSourceLocation(), this.idAllocator.getNextId(), source, Optional.of(target), this.variableAllocator.newVariable("rows", (Type)BigintType.BIGINT), this.variableAllocator.newVariable("fragments", (Type)VarbinaryType.VARBINARY), this.variableAllocator.newVariable("commitcontext", (Type)VarbinaryType.VARBINARY), plan.getFieldMappings(), columnNames, notNullColumnVariables, tablePartitioningScheme, preferredShufflePartitioningScheme, Optional.empty()), Optional.of(target), this.variableAllocator.newVariable("rows", (Type)BigintType.BIGINT), Optional.empty(), Optional.empty());
        return new RelationPlan(commitNode, analysis.getRootScope(), commitNode.getOutputVariables());
    }

    private RelationPlan createDeletePlan(Analysis analysis, Delete node) {
        DeleteNode deleteNode = new QueryPlanner(analysis, this.variableAllocator, this.idAllocator, LogicalPlanner.buildLambdaDeclarationToVariableMap(analysis, this.variableAllocator), this.metadata, this.session).plan(node);
        TableHandle handle = analysis.getTableHandle(node.getTable());
        TableWriterNode.DeleteHandle deleteHandle = new TableWriterNode.DeleteHandle(handle, this.metadata.getTableMetadata(this.session, handle).getTable());
        TableFinishNode commitNode = new TableFinishNode(deleteNode.getSourceLocation(), this.idAllocator.getNextId(), deleteNode, Optional.of(deleteHandle), this.variableAllocator.newVariable("rows", (Type)BigintType.BIGINT), Optional.empty(), Optional.empty());
        return new RelationPlan(commitNode, analysis.getScope((Node)node), commitNode.getOutputVariables());
    }

    private PlanNode createOutputPlan(RelationPlan plan, Analysis analysis) {
        ImmutableList.Builder outputs = ImmutableList.builder();
        ImmutableList.Builder names = ImmutableList.builder();
        int columnNumber = 0;
        RelationType outputDescriptor = analysis.getOutputDescriptor();
        for (Field field : outputDescriptor.getVisibleFields()) {
            String name = field.getName().orElse("_col" + columnNumber);
            names.add((Object)name);
            int fieldIndex = outputDescriptor.indexOf(field);
            VariableReferenceExpression variable = plan.getVariable(fieldIndex);
            outputs.add((Object)variable);
            ++columnNumber;
        }
        return new OutputNode(plan.getRoot().getSourceLocation(), this.idAllocator.getNextId(), plan.getRoot(), (List<String>)names.build(), (List<VariableReferenceExpression>)outputs.build());
    }

    private RelationPlan createRelationPlan(Analysis analysis, Query query) {
        return (RelationPlan)new RelationPlanner(analysis, this.variableAllocator, this.idAllocator, LogicalPlanner.buildLambdaDeclarationToVariableMap(analysis, this.variableAllocator), this.metadata, this.session).process((Node)query, null);
    }

    private ConnectorTableMetadata createTableMetadata(QualifiedObjectName table, List<ColumnMetadata> columns, Map<String, Expression> propertyExpressions, Map<NodeRef<Parameter>, Expression> parameters, Optional<String> comment) {
        ConnectorId connectorId = this.metadata.getCatalogHandle(this.session, table.getCatalogName()).orElseThrow(() -> new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, "Catalog does not exist: " + table.getCatalogName()));
        Map<String, Object> properties = this.metadata.getTablePropertyManager().getProperties(connectorId, table.getCatalogName(), propertyExpressions, this.session, this.metadata, parameters);
        return new ConnectorTableMetadata(MetadataUtil.toSchemaTableName(table), columns, properties, comment);
    }

    private static List<ColumnMetadata> getOutputTableColumns(RelationPlan plan, Optional<List<Identifier>> columnAliases) {
        ImmutableList.Builder columns = ImmutableList.builder();
        int aliasPosition = 0;
        for (Field field : plan.getDescriptor().getVisibleFields()) {
            String columnName = columnAliases.isPresent() ? columnAliases.get().get(aliasPosition).getValue() : field.getName().get();
            columns.add((Object)new ColumnMetadata(columnName, field.getType()));
            ++aliasPosition;
        }
        return columns.build();
    }

    private static Map<NodeRef<LambdaArgumentDeclaration>, VariableReferenceExpression> buildLambdaDeclarationToVariableMap(Analysis analysis, PlanVariableAllocator variableAllocator) {
        LinkedHashMap<NodeRef<LambdaArgumentDeclaration>, VariableReferenceExpression> resultMap = new LinkedHashMap<NodeRef<LambdaArgumentDeclaration>, VariableReferenceExpression>();
        for (Map.Entry<NodeRef<Expression>, Type> entry : analysis.getTypes().entrySet()) {
            NodeRef lambdaArgumentDeclaration;
            if (!(entry.getKey().getNode() instanceof LambdaArgumentDeclaration) || resultMap.containsKey(lambdaArgumentDeclaration = NodeRef.of((Node)((LambdaArgumentDeclaration)entry.getKey().getNode())))) continue;
            resultMap.put((NodeRef<LambdaArgumentDeclaration>)lambdaArgumentDeclaration, variableAllocator.newVariable((Expression)lambdaArgumentDeclaration.getNode(), entry.getValue()));
        }
        return resultMap;
    }

    private static Optional<PartitioningScheme> getPartitioningSchemeForTableWrite(Optional<NewTableLayout> tableLayout, List<String> columnNames, List<VariableReferenceExpression> variables) {
        tableLayout.ifPresent(layout -> {
            if (!ImmutableSet.copyOf((Collection)columnNames).containsAll(layout.getPartitionColumns())) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "INSERT must write all distribution columns: " + layout.getPartitionColumns());
            }
        });
        Optional<PartitioningScheme> partitioningScheme = Optional.empty();
        if (tableLayout.isPresent()) {
            ArrayList partitionFunctionArguments = new ArrayList();
            tableLayout.get().getPartitionColumns().stream().mapToInt(columnNames::indexOf).mapToObj(variables::get).forEach(partitionFunctionArguments::add);
            ArrayList<VariableReferenceExpression> outputLayout = new ArrayList<VariableReferenceExpression>(variables);
            partitioningScheme = Optional.of(new PartitioningScheme(Partitioning.create(tableLayout.get().getPartitioning(), partitionFunctionArguments), outputLayout));
        }
        return partitioningScheme;
    }

    public static enum Stage {
        CREATED,
        OPTIMIZED,
        OPTIMIZED_AND_VALIDATED;

    }
}

