/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.cost.CostCalculatorWithEstimatedExchanges;
import com.facebook.presto.cost.CostComparator;
import com.facebook.presto.cost.LocalCostEstimate;
import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.cost.StatsProvider;
import com.facebook.presto.cost.TaskCountEstimator;
import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.PlanNodeWithCost;
import com.facebook.presto.sql.planner.optimizations.QueryCardinalityUtil;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.google.common.collect.Ordering;
import io.airlift.units.DataSize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class DetermineJoinDistributionType
implements Rule<JoinNode> {
    private static final Pattern<JoinNode> PATTERN = Patterns.join().matching(joinNode -> !joinNode.getDistributionType().isPresent());
    private final CostComparator costComparator;
    private final TaskCountEstimator taskCountEstimator;

    public DetermineJoinDistributionType(CostComparator costComparator, TaskCountEstimator taskCountEstimator) {
        this.costComparator = Objects.requireNonNull(costComparator, "costComparator is null");
        this.taskCountEstimator = Objects.requireNonNull(taskCountEstimator, "taskCountEstimator is null");
    }

    @Override
    public Pattern<JoinNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(JoinNode joinNode, Captures captures, Rule.Context context) {
        FeaturesConfig.JoinDistributionType joinDistributionType = SystemSessionProperties.getJoinDistributionType(context.getSession());
        if (joinDistributionType == FeaturesConfig.JoinDistributionType.AUTOMATIC) {
            return Rule.Result.ofPlanNode(this.getCostBasedJoin(joinNode, context));
        }
        return Rule.Result.ofPlanNode(this.getSyntacticOrderJoin(joinNode, context, joinDistributionType));
    }

    public static boolean isBelowMaxBroadcastSize(JoinNode joinNode, Rule.Context context) {
        DataSize joinMaxBroadcastTableSize = SystemSessionProperties.getJoinMaxBroadcastTableSize(context.getSession());
        PlanNode buildSide = joinNode.getRight();
        PlanNodeStatsEstimate buildSideStatsEstimate = context.getStatsProvider().getStats(buildSide);
        double buildSideSizeInBytes = buildSideStatsEstimate.getOutputSizeInBytes(buildSide.getOutputVariables());
        return buildSideSizeInBytes <= (double)joinMaxBroadcastTableSize.toBytes();
    }

    private PlanNode getCostBasedJoin(JoinNode joinNode, Rule.Context context) {
        ArrayList<PlanNodeWithCost> possibleJoinNodes = new ArrayList<PlanNodeWithCost>();
        this.addJoinsWithDifferentDistributions(joinNode, possibleJoinNodes, context);
        this.addJoinsWithDifferentDistributions(joinNode.flipChildren(), possibleJoinNodes, context);
        if (possibleJoinNodes.stream().anyMatch(result -> result.getCost().hasUnknownComponents()) || possibleJoinNodes.isEmpty()) {
            return this.getSyntacticOrderJoin(joinNode, context, FeaturesConfig.JoinDistributionType.AUTOMATIC);
        }
        Ordering planNodeOrderings = this.costComparator.forSession(context.getSession()).onResultOf(PlanNodeWithCost::getCost);
        return ((PlanNodeWithCost)planNodeOrderings.min(possibleJoinNodes)).getPlanNode();
    }

    private void addJoinsWithDifferentDistributions(JoinNode joinNode, List<PlanNodeWithCost> possibleJoinNodes, Rule.Context context) {
        if (!this.mustPartition(joinNode) && DetermineJoinDistributionType.isBelowMaxBroadcastSize(joinNode, context)) {
            possibleJoinNodes.add(this.getJoinNodeWithCost(context, joinNode.withDistributionType(JoinNode.DistributionType.REPLICATED)));
        }
        if (!DetermineJoinDistributionType.mustReplicate(joinNode, context) && !joinNode.getCriteria().isEmpty()) {
            possibleJoinNodes.add(this.getJoinNodeWithCost(context, joinNode.withDistributionType(JoinNode.DistributionType.PARTITIONED)));
        }
    }

    private PlanNode getSyntacticOrderJoin(JoinNode joinNode, Rule.Context context, FeaturesConfig.JoinDistributionType joinDistributionType) {
        if (this.mustPartition(joinNode)) {
            return joinNode.withDistributionType(JoinNode.DistributionType.PARTITIONED);
        }
        if (DetermineJoinDistributionType.mustReplicate(joinNode, context)) {
            return joinNode.withDistributionType(JoinNode.DistributionType.REPLICATED);
        }
        if (joinDistributionType.canPartition()) {
            return joinNode.withDistributionType(JoinNode.DistributionType.PARTITIONED);
        }
        return joinNode.withDistributionType(JoinNode.DistributionType.REPLICATED);
    }

    private boolean mustPartition(JoinNode joinNode) {
        return joinNode.getType().mustPartition();
    }

    private static boolean mustReplicate(JoinNode joinNode, Rule.Context context) {
        if (joinNode.getType().mustReplicate(joinNode.getCriteria())) {
            return true;
        }
        return QueryCardinalityUtil.isAtMostScalar(joinNode.getRight(), context.getLookup());
    }

    private PlanNodeWithCost getJoinNodeWithCost(Rule.Context context, JoinNode possibleJoinNode) {
        StatsProvider stats = context.getStatsProvider();
        boolean replicated = possibleJoinNode.getDistributionType().get().equals((Object)JoinNode.DistributionType.REPLICATED);
        int estimatedSourceDistributedTaskCount = this.taskCountEstimator.estimateSourceDistributedTaskCount();
        LocalCostEstimate cost = CostCalculatorWithEstimatedExchanges.calculateJoinCostWithoutOutput(possibleJoinNode.getLeft(), possibleJoinNode.getRight(), stats, replicated, estimatedSourceDistributedTaskCount);
        return new PlanNodeWithCost(cost.toPlanCost(), possibleJoinNode);
    }
}

