/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.matching.Capture;
import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.PlanVariableAllocator;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.Util;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public abstract class ProjectOffPushDownRule<N extends PlanNode>
implements Rule<ProjectNode> {
    private final Capture<N> targetCapture = Capture.newCapture();
    private final Pattern<N> targetPattern;

    protected ProjectOffPushDownRule(Pattern<N> targetPattern) {
        this.targetPattern = targetPattern;
    }

    @Override
    public Pattern<ProjectNode> getPattern() {
        return Patterns.project().with(Patterns.source().matching(this.targetPattern.capturedAs(this.targetCapture)));
    }

    @Override
    public Rule.Result apply(ProjectNode parent, Captures captures, Rule.Context context) {
        PlanNode targetNode = (PlanNode)captures.get(this.targetCapture);
        return Util.pruneInputs(targetNode.getOutputVariables(), (Collection)parent.getAssignments().getExpressions().stream().collect(ImmutableList.toImmutableList()), context.getVariableAllocator().getTypes()).flatMap(prunedOutputs -> this.pushDownProjectOff(context.getIdAllocator(), context.getVariableAllocator(), (N)targetNode, (Set<VariableReferenceExpression>)prunedOutputs)).map(newChild -> parent.replaceChildren((List)ImmutableList.of((Object)newChild))).map(Rule.Result::ofPlanNode).orElse(Rule.Result.empty());
    }

    protected abstract Optional<PlanNode> pushDownProjectOff(PlanNodeIdAllocator var1, PlanVariableAllocator var2, N var3, Set<VariableReferenceExpression> var4);
}

